﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using AphroditePiano.VO;
using System.Windows.Threading;
using AphroditePiano.Controls;

namespace AphroditePiano
{
	public partial class Indication : UserControl
	{
        private MusicVO music;

        #region musicVO (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public MusicVO musicVO
        {
            get { return (MusicVO)GetValue(musicVOProperty); }
            set { SetValue(musicVOProperty, value); }
        }
        public static readonly DependencyProperty musicVOProperty =
            DependencyProperty.Register("musicVO", typeof(MusicVO), typeof(Indication),
            new PropertyMetadata(null, new PropertyChangedCallback(OnmusicVOChanged)));

        private static void OnmusicVOChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((Indication)d).OnmusicVOChanged(e);
        }

        protected virtual void OnmusicVOChanged(DependencyPropertyChangedEventArgs e)
        {
            VisualStateManager.GoToState(this, "Stop", true);
            this.music = e.NewValue as MusicVO;

            gapTimer.Stop();
            paragraphTimer.Stop();
            keyIndex = 0;
        }

        #endregion

		public Indication()
		{
			// Required to initialize variables
			InitializeComponent();
            BtnStart.Click += new RoutedEventHandler(BtnStart_Click);
            gapTimer.Tick += new EventHandler(gapTimer_Tick);
            paragraphTimer.Tick += new EventHandler(paragraphTimer_Tick);
        }

        #region PlaySpeed (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public double PlaySpeed
        {
            get { return (double)GetValue(PlaySpeedProperty); }
            set { SetValue(PlaySpeedProperty, value); }
        }
        public static readonly DependencyProperty PlaySpeedProperty =
            DependencyProperty.Register("PlaySpeed", typeof(double), typeof(Indication),
            new PropertyMetadata(0.0, new PropertyChangedCallback(OnPlaySpeedChanged)));

        private static void OnPlaySpeedChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((Indication)d).OnPlaySpeedChanged(e);
        }

        protected virtual void OnPlaySpeedChanged(DependencyPropertyChangedEventArgs e)
        {
            double tempValue = 0.4 - (double)e.NewValue;
            gapTimeSpan = TimeSpan.FromSeconds(tempValue);
            paragraphTimeSpan = TimeSpan.FromSeconds(tempValue * 2);
            gapTimer.Interval = gapTimeSpan;
            paragraphTimer.Interval = paragraphTimeSpan;
        }

        #endregion

        public TimeSpan gapTimeSpan = TimeSpan.FromSeconds(.4);
        public TimeSpan paragraphTimeSpan = TimeSpan.FromSeconds(.8);
        public DispatcherTimer gapTimer = new DispatcherTimer();
        public DispatcherTimer paragraphTimer = new DispatcherTimer();

        public string[] keys;

        public int keyIndex = 0;

        void paragraphTimer_Tick(object sender, EventArgs e)
        {
            paragraphTimer.Stop();
            gapTimer.Start();
        }

        void gapTimer_Tick(object sender, EventArgs e)
        {
            //UpAllKeys();
            if (keyIndex < keys.Length - 1)
            {
                if (keys[keyIndex] != "|")
                {
                    string ks = keys[keyIndex].Replace("&", string.Empty);
                    IndicationKey ikey = new IndicationKey();
                    ikey.setTxt(ks);
                    ikey.HorizontalAlignment = HorizontalAlignment.Right;
                    ikey.VerticalAlignment = VerticalAlignment.Center;
                    xGrid.Children.Add(ikey);
                    ikey.run();
                }
                else
                {
                    gapTimer.Stop();
                    paragraphTimer.Start();
                }
                keyIndex++;
            }
            else
            {
                gapTimer.Stop();
                paragraphTimer.Stop();
                keyIndex = 0;
            }
        }


        void BtnStart_Click(object sender, RoutedEventArgs e)
        {
            if (this.music != null)
            {
                VisualStateManager.GoToState(this, "Start", true);

                keyIndex = 0;
                gapTimer.Interval = gapTimeSpan;
                paragraphTimer.Interval = paragraphTimeSpan;

                keys = music.PassKey.Split(',');

                gapTimer.Start();
            }
        }
	}
}