﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using AphroditePiano.Model;
using System.Windows.Data;

namespace AphroditePiano.Controls
{
    public partial class SoundManager : UserControl
    {
        // MediaElement 控件总数
        private int _count = 32;

        // MediaElement 控件集合的索
        private int _index = 0;

        private List<MediaElement> listMediaElement;

        #region SoundVolume (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public double SoundVolume
        {
            get { return (double)GetValue(SoundVolumeProperty); }
            set { SetValue(SoundVolumeProperty, value); }
        }
        public static readonly DependencyProperty SoundVolumeProperty =
            DependencyProperty.Register("SoundVolume", typeof(double), typeof(SoundManager),
            new PropertyMetadata(1.0, new PropertyChangedCallback(OnSoundVolumeChanged)));

        private static void OnSoundVolumeChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnSoundVolumeChanged(e);
        }

        protected virtual void OnSoundVolumeChanged(DependencyPropertyChangedEventArgs e)
        {
            foreach (MediaElement media in listMediaElement) {
                media.Volume = (double)e.NewValue;
            }
        }

        #endregion



        #region IsQDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsQDown
        {
            get { return (bool)GetValue(IsQDownProperty); }
            set { SetValue(IsQDownProperty, value); }
        }
        public static readonly DependencyProperty IsQDownProperty =
            DependencyProperty.Register("IsQDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsQDownChanged)));

        private static void OnIsQDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsQDownChanged(e);
        }

        protected virtual void OnIsQDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.Q);
            }
        }

        #endregion

        #region IsWDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsWDown
        {
            get { return (bool)GetValue(IsWDownProperty); }
            set { SetValue(IsWDownProperty, value); }
        }
        public static readonly DependencyProperty IsWDownProperty =
            DependencyProperty.Register("IsWDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsWDownChanged)));

        private static void OnIsWDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsWDownChanged(e);
        }

        protected virtual void OnIsWDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.W);
            }
        }

        #endregion

        #region IsEDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsEDown
        {
            get { return (bool)GetValue(IsEDownProperty); }
            set { SetValue(IsEDownProperty, value); }
        }
        public static readonly DependencyProperty IsEDownProperty =
            DependencyProperty.Register("IsEDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsEDownChanged)));

        private static void OnIsEDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsEDownChanged(e);
        }

        protected virtual void OnIsEDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.E);
            }
        }

        #endregion

        #region IsRDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsRDown
        {
            get { return (bool)GetValue(IsRDownProperty); }
            set { SetValue(IsRDownProperty, value); }
        }
        public static readonly DependencyProperty IsRDownProperty =
            DependencyProperty.Register("IsRDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsRDownChanged)));

        private static void OnIsRDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsRDownChanged(e);
        }

        protected virtual void OnIsRDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.R);
            }
        }

        #endregion

        #region IsTDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsTDown
        {
            get { return (bool)GetValue(IsTDownProperty); }
            set { SetValue(IsTDownProperty, value); }
        }
        public static readonly DependencyProperty IsTDownProperty =
            DependencyProperty.Register("IsTDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsTDownChanged)));

        private static void OnIsTDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsTDownChanged(e);
        }

        protected virtual void OnIsTDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.T);
            }
        }

        #endregion

        #region IsYDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsYDown
        {
            get { return (bool)GetValue(IsYDownProperty); }
            set { SetValue(IsYDownProperty, value); }
        }
        public static readonly DependencyProperty IsYDownProperty =
            DependencyProperty.Register("IsYDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsYDownChanged)));

        private static void OnIsYDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsYDownChanged(e);
        }

        protected virtual void OnIsYDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.Y);
            }
        }

        #endregion

        #region IsUDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsUDown
        {
            get { return (bool)GetValue(IsUDownProperty); }
            set { SetValue(IsUDownProperty, value); }
        }
        public static readonly DependencyProperty IsUDownProperty =
            DependencyProperty.Register("IsUDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsUDownChanged)));

        private static void OnIsUDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsUDownChanged(e);
        }

        protected virtual void OnIsUDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.U);
            }
        }

        #endregion

        #region IsIDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsIDown
        {
            get { return (bool)GetValue(IsIDownProperty); }
            set { SetValue(IsIDownProperty, value); }
        }
        public static readonly DependencyProperty IsIDownProperty =
            DependencyProperty.Register("IsIDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsIDownChanged)));

        private static void OnIsIDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsIDownChanged(e);
        }

        protected virtual void OnIsIDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.I);
            }
        }

        #endregion

        #region IsODown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsODown
        {
            get { return (bool)GetValue(IsODownProperty); }
            set { SetValue(IsODownProperty, value); }
        }
        public static readonly DependencyProperty IsODownProperty =
            DependencyProperty.Register("IsODown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsODownChanged)));

        private static void OnIsODownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsODownChanged(e);
        }

        protected virtual void OnIsODownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.O);
            }
        }

        #endregion

        #region IsPDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsPDown
        {
            get { return (bool)GetValue(IsPDownProperty); }
            set { SetValue(IsPDownProperty, value); }
        }
        public static readonly DependencyProperty IsPDownProperty =
            DependencyProperty.Register("IsPDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsPDownChanged)));

        private static void OnIsPDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsPDownChanged(e);
        }

        protected virtual void OnIsPDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.P);
            }
        }

        #endregion

        #region IsADown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsADown
        {
            get { return (bool)GetValue(IsADownProperty); }
            set { SetValue(IsADownProperty, value); }
        }
        public static readonly DependencyProperty IsADownProperty =
            DependencyProperty.Register("IsADown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsADownChanged)));

        private static void OnIsADownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsADownChanged(e);
        }

        protected virtual void OnIsADownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.A);
            }
        }

        #endregion

        #region IsSDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsSDown
        {
            get { return (bool)GetValue(IsSDownProperty); }
            set { SetValue(IsSDownProperty, value); }
        }
        public static readonly DependencyProperty IsSDownProperty =
            DependencyProperty.Register("IsSDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsSDownChanged)));

        private static void OnIsSDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsSDownChanged(e);
        }

        protected virtual void OnIsSDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.S);
            }
        }

        #endregion

        #region IsDDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsDDown
        {
            get { return (bool)GetValue(IsDDownProperty); }
            set { SetValue(IsDDownProperty, value); }
        }
        public static readonly DependencyProperty IsDDownProperty =
            DependencyProperty.Register("IsDDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsDDownChanged)));

        private static void OnIsDDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsDDownChanged(e);
        }

        protected virtual void OnIsDDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.D);
            }
        }

        #endregion

        #region IsFDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsFDown
        {
            get { return (bool)GetValue(IsFDownProperty); }
            set { SetValue(IsFDownProperty, value); }
        }
        public static readonly DependencyProperty IsFDownProperty =
            DependencyProperty.Register("IsFDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsFDownChanged)));

        private static void OnIsFDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsFDownChanged(e);
        }

        protected virtual void OnIsFDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.F);
            }
        }

        #endregion

        #region IsGDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsGDown
        {
            get { return (bool)GetValue(IsGDownProperty); }
            set { SetValue(IsGDownProperty, value); }
        }
        public static readonly DependencyProperty IsGDownProperty =
            DependencyProperty.Register("IsGDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsGDownChanged)));

        private static void OnIsGDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsGDownChanged(e);
        }

        protected virtual void OnIsGDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.G);
            }
        }

        #endregion

        #region IsHDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsHDown
        {
            get { return (bool)GetValue(IsHDownProperty); }
            set { SetValue(IsHDownProperty, value); }
        }
        public static readonly DependencyProperty IsHDownProperty =
            DependencyProperty.Register("IsHDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsHDownChanged)));

        private static void OnIsHDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsHDownChanged(e);
        }

        protected virtual void OnIsHDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.H);
            }
        }

        #endregion

        #region IsJDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsJDown
        {
            get { return (bool)GetValue(IsJDownProperty); }
            set { SetValue(IsJDownProperty, value); }
        }
        public static readonly DependencyProperty IsJDownProperty =
            DependencyProperty.Register("IsJDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsJDownChanged)));

        private static void OnIsJDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsJDownChanged(e);
        }

        protected virtual void OnIsJDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.J);
            }
        }

        #endregion

        #region IsKDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsKDown
        {
            get { return (bool)GetValue(IsKDownProperty); }
            set { SetValue(IsKDownProperty, value); }
        }
        public static readonly DependencyProperty IsKDownProperty =
            DependencyProperty.Register("IsKDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsKDownChanged)));

        private static void OnIsKDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsKDownChanged(e);
        }

        protected virtual void OnIsKDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.K);
            }
        }

        #endregion

        #region IsLDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsLDown
        {
            get { return (bool)GetValue(IsLDownProperty); }
            set { SetValue(IsLDownProperty, value); }
        }
        public static readonly DependencyProperty IsLDownProperty =
            DependencyProperty.Register("IsLDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsLDownChanged)));

        private static void OnIsLDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsLDownChanged(e);
        }

        protected virtual void OnIsLDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.L);
            }
        }

        #endregion

        #region IsZDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsZDown
        {
            get { return (bool)GetValue(IsZDownProperty); }
            set { SetValue(IsZDownProperty, value); }
        }
        public static readonly DependencyProperty IsZDownProperty =
            DependencyProperty.Register("IsZDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsZDownChanged)));

        private static void OnIsZDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsZDownChanged(e);
        }

        protected virtual void OnIsZDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.Z);
            }
        }

        #endregion

        #region IsXDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsXDown
        {
            get { return (bool)GetValue(IsXDownProperty); }
            set { SetValue(IsXDownProperty, value); }
        }
        public static readonly DependencyProperty IsXDownProperty =
            DependencyProperty.Register("IsXDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsXDownChanged)));

        private static void OnIsXDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsXDownChanged(e);
        }

        protected virtual void OnIsXDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.X);
            }
        }

        #endregion

        #region IsCDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsCDown
        {
            get { return (bool)GetValue(IsCDownProperty); }
            set { SetValue(IsCDownProperty, value); }
        }
        public static readonly DependencyProperty IsCDownProperty =
            DependencyProperty.Register("IsCDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsCDownChanged)));

        private static void OnIsCDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsCDownChanged(e);
        }

        protected virtual void OnIsCDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.C);
            }
        }

        #endregion

        #region IsVDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsVDown
        {
            get { return (bool)GetValue(IsVDownProperty); }
            set { SetValue(IsVDownProperty, value); }
        }
        public static readonly DependencyProperty IsVDownProperty =
            DependencyProperty.Register("IsVDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsVDownChanged)));

        private static void OnIsVDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsVDownChanged(e);
        }

        protected virtual void OnIsVDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.V);
            }
        }

        #endregion

        #region IsBDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsBDown
        {
            get { return (bool)GetValue(IsBDownProperty); }
            set { SetValue(IsBDownProperty, value); }
        }
        public static readonly DependencyProperty IsBDownProperty =
            DependencyProperty.Register("IsBDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsBDownChanged)));

        private static void OnIsBDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsBDownChanged(e);
        }

        protected virtual void OnIsBDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.B);
            }
        }

        #endregion

        #region IsNDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsNDown
        {
            get { return (bool)GetValue(IsNDownProperty); }
            set { SetValue(IsNDownProperty, value); }
        }
        public static readonly DependencyProperty IsNDownProperty =
            DependencyProperty.Register("IsNDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsNDownChanged)));

        private static void OnIsNDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsNDownChanged(e);
        }

        protected virtual void OnIsNDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.N);
            }
        }

        #endregion

        #region IsMDown (DependencyProperty)

        /// <summary>
        /// A description of the property.
        /// </summary>
        public bool IsMDown
        {
            get { return (bool)GetValue(IsMDownProperty); }
            set { SetValue(IsMDownProperty, value); }
        }
        public static readonly DependencyProperty IsMDownProperty =
            DependencyProperty.Register("IsMDown", typeof(bool), typeof(SoundManager),
            new PropertyMetadata(false, new PropertyChangedCallback(OnIsMDownChanged)));

        private static void OnIsMDownChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((SoundManager)d).OnIsMDownChanged(e);
        }

        protected virtual void OnIsMDownChanged(DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue)
            {
                Play(Key.M);
            }
        }

        #endregion



        public SoundManager()
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(SoundManager_Loaded);
        }

        void SoundManager_Loaded(object sender, RoutedEventArgs e)
        {
            listMediaElement = new List<MediaElement>();
            // 在 Canvas 上添加指定数量的 MediaElement 控件
            for (int i = 0; i < _count; i++)
            {
                var element = new MediaElement();
                element.Volume = .5;

                LayoutRoot.Children.Add(element);
                listMediaElement.Add(element);
            }
            this.DataContext = SLKeyBoardModel.Instance;

            Binding bindIsQDown = new Binding("IsQDown");
            bindIsQDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsQDownProperty, bindIsQDown);


            Binding bindIsWDown = new Binding("IsWDown");
            bindIsWDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsWDownProperty, bindIsWDown);


            Binding bindIsEDown = new Binding("IsEDown");
            bindIsEDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsEDownProperty, bindIsEDown);


            Binding bindIsRDown = new Binding("IsRDown");
            bindIsRDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsRDownProperty, bindIsRDown);


            Binding bindIsTDown = new Binding("IsTDown");
            bindIsTDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsTDownProperty, bindIsTDown);


            Binding bindIsYDown = new Binding("IsYDown");
            bindIsYDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsYDownProperty, bindIsYDown);


            Binding bindIsUDown = new Binding("IsUDown");
            bindIsUDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsUDownProperty, bindIsUDown);


            Binding bindIsIDown = new Binding("IsIDown");
            bindIsIDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsIDownProperty, bindIsIDown);


            Binding bindIsODown = new Binding("IsODown");
            bindIsODown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsODownProperty, bindIsODown);


            Binding bindIsPDown = new Binding("IsPDown");
            bindIsPDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsPDownProperty, bindIsPDown);


            Binding bindIsADown = new Binding("IsADown");
            bindIsADown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsADownProperty, bindIsADown);


            Binding bindIsSDown = new Binding("IsSDown");
            bindIsSDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsSDownProperty, bindIsSDown);


            Binding bindIsDDown = new Binding("IsDDown");
            bindIsDDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsDDownProperty, bindIsDDown);


            Binding bindIsFDown = new Binding("IsFDown");
            bindIsFDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsFDownProperty, bindIsFDown);


            Binding bindIsGDown = new Binding("IsGDown");
            bindIsGDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsGDownProperty, bindIsGDown);


            Binding bindIsHDown = new Binding("IsHDown");
            bindIsHDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsHDownProperty, bindIsHDown);


            Binding bindIsJDown = new Binding("IsJDown");
            bindIsJDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsJDownProperty, bindIsJDown);


            Binding bindIsKDown = new Binding("IsKDown");
            bindIsKDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsKDownProperty, bindIsKDown);


            Binding bindIsLDown = new Binding("IsLDown");
            bindIsLDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsLDownProperty, bindIsLDown);


            Binding bindIsZDown = new Binding("IsZDown");
            bindIsZDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsZDownProperty, bindIsZDown);


            Binding bindIsXDown = new Binding("IsXDown");
            bindIsXDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsXDownProperty, bindIsXDown);


            Binding bindIsCDown = new Binding("IsCDown");
            bindIsCDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsCDownProperty, bindIsCDown);


            Binding bindIsVDown = new Binding("IsVDown");
            bindIsVDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsVDownProperty, bindIsVDown);


            Binding bindIsBDown = new Binding("IsBDown");
            bindIsBDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsBDownProperty, bindIsBDown);


            Binding bindIsNDown = new Binding("IsNDown");
            bindIsNDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsNDownProperty, bindIsNDown);


            Binding bindIsMDown = new Binding("IsMDown");
            bindIsMDown.Mode = BindingMode.TwoWay;
            this.SetBinding(IsMDownProperty, bindIsMDown);

        }

        /// <summary>
        /// 播放音阶
        /// A 键对应 Sound 文件夹内的 A.mp3，以此类推
        /// A 键对应 C 大调的低音 dou，以此类推
        /// </summary>
        /// <param name="key">键值</param>
        public void Play(Key key)
        {
            if (key >= Key.A && key <= Key.Z)
            {
                // 循环使用 MediaElement 控件集合中的控件
                if (_index > _count - 1)
                    _index = 0;

                // 设置 MediaElement 的 Source 并播放
                var element = LayoutRoot.Children[_index] as MediaElement;
                element.Source =  new Uri("/AphroditePiano;component/Sound/" + key.ToString() + ".mp3", UriKind.Relative);
                element.Stop();
                element.Play();

                _index++;
            }
        }

    }
}
