﻿using System.ComponentModel;
using System.Collections.Generic;
using System.Windows.Input;

namespace AphroditePiano.VO
{
    public class MusicVO : INotifyPropertyChanged
    {
        private string _Title;
        private string _PassKey;
        private int _Level;

        public event PropertyChangedEventHandler PropertyChanged;
        private void NotifyPropertyChanged(string name)
        {
            if (this.PropertyChanged != null)
            {
                this.PropertyChanged(this, new PropertyChangedEventArgs(name));
            }
        }

        public string Title
        {
            get { return this._Title; }
            set
            {
                this._Title = value;
                this.NotifyPropertyChanged("Title");
            }
        }

        public string PassKey
        {
            get { return this._PassKey; }
            set
            {
                this._PassKey = value;
                this.NotifyPropertyChanged("PassKey");
            }
        }
        public int Level
        {
            get { return this._Level; }
            set
            {
                this._Level = value;
                this.NotifyPropertyChanged("Level");
            }
        }

    }
}
