﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Reflection;
using System.Windows.Browser;
using System.IO;
using System.Windows.Resources;
using System.Xml.Linq;
//５１ａsｐx
namespace AphroditePianoLoading
{
    public partial class Page : UserControl
    {
        public Assembly assembly;

        public Page()
        {
            InitializeComponent();
            VisualStateManager.GoToState(this, "loading", true);
            this.Init();
        }
        private void Init()
        {
            Uri address = new Uri(HtmlPage.Document.DocumentUri, "ClientBin/AphroditePiano.xap");
            WebClient webClient = new WebClient();
            webClient.OpenReadCompleted += new OpenReadCompletedEventHandler(webClient_OpenReadCompleted);
            webClient.DownloadProgressChanged += new DownloadProgressChangedEventHandler(webClient_DownloadProgressChanged);
            webClient.OpenReadAsync(address);
        }

        void webClient_DownloadProgressChanged(object sender, DownloadProgressChangedEventArgs e)
        {
            //在这里实现你的loading动画
            xProgressBar.Value = e.ProgressPercentage;
        }

        void webClient_OpenReadCompleted(object sender, OpenReadCompletedEventArgs e)
        {
            assembly = LoadAssemblyFromXap(e.Result, "AphroditePiano.dll");
            VisualStateManager.GoToState(this, "ready", true);
        }

        Assembly LoadAssemblyFromXap(Stream packageStream, String assemblyName)
        {
            Stream stream = Application.GetResourceStream(
                    new StreamResourceInfo(packageStream, null),
                    new Uri("AppManifest.xaml", UriKind.Relative)).Stream;

            String appManifestString = new StreamReader(stream).ReadToEnd();

            XElement deploy = XDocument.Parse(appManifestString).Root;

            List<XElement> parts = (from assemblyParts in deploy.Elements().Elements()
                                    select assemblyParts
                                    ).ToList();
            Assembly assembly = null;
            foreach (XElement xe in parts)
            {
                String source = xe.Attribute("Source").Value;
                AssemblyPart asmPart = new AssemblyPart();
                StreamResourceInfo streamInfo = Application.GetResourceStream(
                                                new StreamResourceInfo(packageStream, "application/binary"),
                                                new Uri(source, UriKind.Relative));

                if (source.Equals(assemblyName))
                {
                    assembly = asmPart.Load(streamInfo.Stream);
                }
                else
                {
                    asmPart.Load(streamInfo.Stream);
                }
            }
            return assembly;
        }

        private void btnPlay_Click(object sender, RoutedEventArgs e)
        {
            UIElement element = assembly.CreateInstance("AphroditePiano.MainPage") as UIElement;
            this.LayoutRoot.Children.Clear();
            this.LayoutRoot.Children.Add(element);
        }
    }
}
