﻿<%@ Application Language="C#" %>

<script runat="server">
    private System.Timers.Timer timer = null;
    void Application_Start(object sender, EventArgs e) 
    {
        // 在应用程序启动时运行的代码
        timer = new System.Timers.Timer(1000000);
        timer.Elapsed += new System.Timers.ElapsedEventHandler(timer_Elapsed);
        timer.Start();
    }

    void timer_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
    {
        //throw new Exception("The method or operation is not implemented.");
        DataSetManagerTableAdapters.UsersTableAdapter userAdapter = new DataSetManagerTableAdapters.UsersTableAdapter();
        DataSetManager.UsersDataTable userTable = new DataSetManager.UsersDataTable();
        DataSetManagerTableAdapters.allCountTableAdapter allCountAdapter = new DataSetManagerTableAdapters.allCountTableAdapter();
        DataSetManager.allCountDataTable allCountTable = new DataSetManager.allCountDataTable();
        allCountTable=allCountAdapter.GetData();
        
        foreach (System.Data.DataRow row in allCountTable.Rows)
        {//扫描一次数据库
            string title = "违规提醒";
            string stuName = "";
            string body = "";
            stuName = row[allCountTable.user_nameColumn].ToString();
            int ifsend =Convert.ToInt32(row[allCountTable.ifsendColumn].ToString());
            string emailAddress = row[allCountTable.emailColumn].ToString();
            int allCount = Convert.ToInt32(row[allCountTable.allCountColumn].ToString());
            int userId = Convert.ToInt32(row[allCountTable.user_idColumn].ToString());
            if (allCount < 2)
            {//要大于一定次数才发送
                continue;
            }
            
            if (ifsend != 0)//邮件已经发送过了就不重复发送了
            {
                continue;
            }
            body = stuName + ":+<br />" + "    你已经违规达到一定次数,请自律,否则学院将按一定的程序做相应的处理 <br /> 教务处<br />"+DateTime.Now.ToShortDateString();
            this.sendMail(title, body, emailAddress, "websidesendemail@126.com", "websidesendemail", "gxcme24008", "smtp.163.com");
            if (userAdapter.UpdateSend(1, userId)==1)
            {
               //测试成功
            }
        }
        
    }
    
    void Application_End(object sender, EventArgs e) 
    {
        //  在应用程序关闭时运行的代码
        timer.Stop();

    }
        
    void Application_Error(object sender, EventArgs e) 
    { 
        // 在出现未处理的错误时运行的代码

    }

    void Session_Start(object sender, EventArgs e) 
    {
        // 在新会话启动时运行的代码

    }

    void Session_End(object sender, EventArgs e) 
    {
        // 在会话结束时运行的代码。 
        // 注意: 只有在 Web.config 文件中的 sessionstate 模式设置为
        // InProc 时，才会引发 Session_End 事件。如果会话模式设置为 StateServer 
        // 或 SQLServer，则不会引发该事件。

    }
    private void sendMail(string title, string body, string toAddress, string fromAdress, string userNamem, string userPwd, string smtpHost)
    {
        try
        {
            System.Net.Mail.MailAddress to = new System.Net.Mail.MailAddress(toAddress);
            System.Net.Mail.MailAddress from = new System.Net.Mail.MailAddress(fromAdress);
            System.Net.Mail.MailMessage message = new System.Net.Mail.MailMessage(from, to);
            message.Subject = title;
            message.Body = body;
            System.Net.Mail.SmtpClient smtp = new System.Net.Mail.SmtpClient();
            smtp.Port = 25; 
            smtp.Credentials = new System.Net.NetworkCredential(userNamem, userPwd);
            smtp.DeliveryMethod = System.Net.Mail.SmtpDeliveryMethod.Network;
            smtp.Host = smtpHost;
            message.To.Add(toAddress);
            smtp.Send(message);
            Response.Write("发送成功！");
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.Message);
        }
    }
       
</script>
