﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DataSetManagerTableAdapters;

public partial class attendcheck : System.Web.UI.Page
{
    AttendQueryTableAdapter attendQAdapter = new AttendQueryTableAdapter();
    DataSetManager.AttendQueryDataTable attendQueryTable = new DataSetManager.AttendQueryDataTable();
    int count;
    string fileName = "考勤数据文件名";
    private void loadTable()
    {
        //设置默认参数,在默认情况下应该查出的是全部的记录
        DateTime dtBegin = DateTime.Parse("2000-01-01"), dtEnd = DateTime.Now;
        string depart = "%", spc = "%", clas = "%", type = "%", name = "%";
        if (txtDateFrom.Text.Trim() != "")
        {
            dtBegin = DateTime.Parse(txtDateFrom.Text.Trim());
        }
        if (txtDateTo.Text.Trim() != "")
        {
            dtEnd = DateTime.Parse(txtDateTo.Text.Trim());
        }
        if (!string.IsNullOrEmpty(ddlDepart.SelectedItem.Text))
        {
            depart = ddlDepart.SelectedItem.Text;
        }
        if (!string.IsNullOrEmpty(ddlSpec.SelectedItem.Text))
        {
            spc = ddlSpec.SelectedItem.Text;
        }
        if (!string.IsNullOrEmpty(ddlClass.SelectedItem.Text))
        {
            clas = ddlClass.SelectedItem.Text;
        }
        if (!string.IsNullOrEmpty(ddlType.SelectedItem.Text))
        {
            type = ddlType.SelectedItem.Text;
        }
        //attendQueryTable = attendQAdapter.GetData();
        count = (int)attendQAdapter.SQCount(dtBegin, dtEnd, depart, spc, clas, type, name);
        Label1.Text = "有" + count + "条记录";
        attendQueryTable = attendQAdapter.GetDataByAndLike(dtBegin, dtEnd, depart, spc, clas, type, name);
        gvAttend.DataSource = attendQueryTable;
        gvAttend.DataBind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (Session["level"] == null || Convert.ToInt32(Session["level"].ToString())<0)
            {//没登陆时不5能1通a过s浏p览x器直接输入地址访问
                Response.Redirect("login.aspx");
            }
        }
        catch (Exception ex)
        {
            Response.Redirect("login.aspx");
        }
        if (!Page.IsPostBack)
        {
            this.loadTable();
        }
    }
    protected void btnCheck_Click(object sender, EventArgs e)
    {
        this.loadTable();
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {

    }
    protected void gvAttend_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        int startIndex;
        int i = gvAttend.PageCount;
        startIndex = gvAttend.PageIndex * gvAttend.PageSize;
        gvAttend.PageIndex = e.NewPageIndex;
        this.loadTable();
    }
    protected void btnOutput_Click(object sender, EventArgs e)
    {//在没用Ajax时成功导出Excel
        //Response.Clear();
        //Response.Buffer = true;
        //Response.Charset = "GB2312";
        //Response.AppendHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
        //Response.ContentEncoding = System.Text.Encoding.GetEncoding("GB2312");
        //Response.ContentType = "application/ms-excel";//设置输出文件类型为excel文件。
        //this.EnableViewState = false;
        //System.Globalization.CultureInfo myCITrad = new System.Globalization.CultureInfo("ZH-CN", true);
        //System.IO.StreamWriter oStringWriter = new System.IO.StreamWriter(myCITrad);
        //System.Web.UI.HtmlTextWriter oHtmlTextWriter = new HtmlTextWriter(oStringWriter);
        //this.gvAttend.RenderControl(oHtmlTextWriter);
        //Response.Write(oHtmlTextWriter.ToString());
    }
}
