﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DataSetManagerTableAdapters;
public partial class attendcount : System.Web.UI.Page
{
    AttCountTableAdapter attcountAdapter = new AttCountTableAdapter();
    DataSetManager.AttCountDataTable attcountTable = new DataSetManager.AttCountDataTable();
    private void loadTable()
    {
        //设置默认参数,在默认情况下应该查出的是全部的记录
        DateTime dtBegin = DateTime.Parse("2000-01-01"), dtEnd = DateTime.Now;
        string depart = "%", spc = "%", clas = "%", type = "%", name = "%";
        if (txtDateFrom.Text.Trim() != "")
        {
            dtBegin = DateTime.Parse(txtDateFrom.Text.Trim());
        }
        if (txtDateTo.Text.Trim() != "")
        {
            dtEnd = DateTime.Parse(txtDateTo.Text.Trim());
        }
        if (!string.IsNullOrEmpty(ddlDepart.SelectedItem.Text))
        {
            depart = ddlDepart.SelectedItem.Text;
        }
        if (!string.IsNullOrEmpty(ddlSpec.SelectedItem.Text))
        {
            spc = ddlSpec.SelectedItem.Text;
        }
        if (!string.IsNullOrEmpty(ddlClass.SelectedItem.Text))
        {
            clas = ddlClass.SelectedItem.Text;
        }
        if (!string.IsNullOrEmpty(ddlType.SelectedItem.Text))
        {
            type = ddlType.SelectedItem.Text;
        }
        attcountTable = attcountAdapter.GetDataByAndLike(name, depart, spc, clas, type, dtBegin, dtEnd, "%");
        gvAttend.DataSource = attcountTable;
        gvAttend.DataBind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (Session["level"] == null || Convert.ToInt32(Session["level"].ToString()) <0)
            {//没登陆时不能通过浏览器直接输入地址访问
                Response.Redirect("login.aspx");
            }
        }
        catch (Exception ex)
        {
            Response.Redirect("login.aspx");
        }
        //if (!Page.IsPostBack)
        //{
        //    this.loadTable();
        //}
        loadTable();
    }
    protected void btnCheck_Click(object sender, EventArgs e)
    {
        this.loadTable();
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {

    }
    protected void gvAttend_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        int startIndex;
        int i = gvAttend.PageCount;
        startIndex = gvAttend.PageIndex * gvAttend.PageSize;
        gvAttend.PageIndex = e.NewPageIndex;
        this.loadTable();
    }
}
