﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DataSetManagerTableAdapters;
public partial class attendview : System.Web.UI.Page
{
    AttendQueryTableAdapter attQueryAdapter = new AttendQueryTableAdapter();
    DataSetManager.AttendQueryDataTable attQueryTable = new DataSetManager.AttendQueryDataTable();
    AttendanceTableAdapter attendanceAdapter = new AttendanceTableAdapter();
    int aid = -1;
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (Session["level"] == null || Convert.ToInt32(Session["level"].ToString()) < 0)
            {//没登陆时不能通过浏览器直接输入地址访问
                Response.Redirect("login.aspx");
            }
            else
            {
                int level = Convert.ToInt32(Session["level"].ToString());
                if (level < 2)
                {//只有管理员才能删除记录
                    btnDelete.Enabled = false;
                }
                else
                {
                    btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除?')");
                }
            }
        }
        catch (Exception ex)
        {
            Response.Redirect("login.aspx");
        }
        if (!Page.IsPostBack)
        {
            
            if (Request["aid"] != null)
            {
                aid = Convert.ToInt32(Request["aid"].ToString());
                attQueryTable = attQueryAdapter.GetDataByAId(aid);
                DataList1.DataSource = attQueryTable;
                DataList1.DataBind();
            }
            else
            {
                Response.Redirect("index.aspx");
            }
        }
    }
    protected void btnBack_Click(object sender, EventArgs e)
    {
        Response.Redirect("attendcheck.aspx");
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        if (attendanceAdapter.DeleteById(aid) == 1)
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('操作成功！')</script>");
            Response.Redirect("attendcheck.aspx");
        }
        else
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('操作失败！')</script>");
        }
    }
}
