﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DataSetManagerTableAdapters;
public partial class lateDetail : System.Web.UI.Page
{
    lateQueryTableAdapter lateQueryAdapter = new lateQueryTableAdapter();
    DataSetManager.lateQueryDataTable dtLate = new DataSetManager.lateQueryDataTable();
    LateTableAdapter lateAdapter = new LateTableAdapter();
    int lid = -1;
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (Session["level"] == null || Convert.ToInt32(Session["level"].ToString()) < 0)
            {//没登陆时不能通过浏览器直接输入地址访问
                Response.Redirect("login.aspx");
            }
            else
            {
                int level = Convert.ToInt32(Session["level"].ToString());
                if (level < 2)
                {//只有管理员才能删除记录
                    btnDelete.Enabled = false;
                }
                else
                {
                    btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除?')");
                }
            }
        }
        catch (Exception ex)
        {
            Response.Redirect("login.aspx");
        }
        if (!Page.IsPostBack)
        {
            
            if (Request["lid"] != null)
            {
                lid =Convert.ToInt32(Request["lid"].ToString());
                dtLate = lateQueryAdapter.GetDataByLid(lid);
                DataList1.DataSource = dtLate;
                DataList1.DataBind();
            }
        }
    }
    protected void btnBack_Click(object sender, EventArgs e)
    {
        Response.Redirect("latecheck.aspx");
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        if (lateAdapter.DeleteById(lid) == 1)
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('操作成功！')</script>");
            Response.Redirect("latecheck.aspx");
        }
        else
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('操作失败！')</script>");
        }
    }
}
