﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DataSetManagerTableAdapters;
public partial class latecheck : System.Web.UI.Page
{
    lateQueryTableAdapter laquadapter = new lateQueryTableAdapter();
    DataSetManager.lateQueryDataTable laquTable = new DataSetManager.lateQueryDataTable();
    int count;
    private void loadTable()
    {
        try
        {
            //设置默认参数,在默认情况下应该查出的是全部的记录
            DateTime dtBegin = DateTime.Parse("2000-01-01"), dtEnd = DateTime.Now;
            string depart = "%", spc = "%", clas = "%", region = "%", name = "%", room = "%";
            if (txtDateFrom.Text.Trim() != "")
            {
                dtBegin = DateTime.Parse(txtDateFrom.Text.Trim());
            }
            if (txtDateTo.Text.Trim() != "")
            {
                dtEnd = DateTime.Parse(txtDateTo.Text.Trim());
            }
            if (!string.IsNullOrEmpty(ddlDepart.SelectedItem.Text))
            {
                depart = ddlDepart.SelectedItem.Text;
            }
            if (!string.IsNullOrEmpty(ddlSpec.SelectedItem.Text))
            {
                spc = ddlSpec.SelectedItem.Text;
            }
            if (!string.IsNullOrEmpty(ddlClass.SelectedItem.Text))
            {
                clas = ddlClass.SelectedItem.Text;
            }
            if (!string.IsNullOrEmpty(ddlRegion.SelectedItem.Text))
            {
                region = ddlRegion.SelectedItem.Text;
            }
            if (txtName.Text.Trim() != "")
            {
                name = txtName.Text.Trim();
            }
            laquTable = laquadapter.GetDataByByAndLike(dtBegin, dtEnd, clas, room, name, depart, spc, region);
            gvLate.DataSource = laquTable;
            gvLate.DataBind();
            count = (int)laquadapter.SQGetCountByAndLike(dtBegin, dtEnd, clas, room, name, depart, spc, region);
            Label1.Text = "共有" + count + "条记录";
        }
        catch (Exception ex)
        {

        }
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (Session["level"] == null || Convert.ToInt32(Session["level"].ToString()) < 0)
            {//没登陆时不能通过浏览器直接输入地址访问
                Response.Redirect("login.aspx");
            }
        }
        catch (Exception ex)
        {
            Response.Redirect("login.aspx");
        }
        if (!Page.IsPostBack)
        {
            this.loadTable();
        }
    }
    protected void btnCheck_Click(object sender, EventArgs e)
    {
        this.loadTable();
    }
    protected void gvLate_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        int startIndex;
        int i = gvLate.PageCount;
        startIndex = gvLate.PageIndex * gvLate.PageSize;
        gvLate.PageIndex = e.NewPageIndex;
        this.loadTable();
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {

    }
}
