﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using DataSetManagerTableAdapters;

public partial class updateUser : System.Web.UI.Page
{
    UsersTableAdapter userAdapter = new UsersTableAdapter();
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (Session["level"] == null || Convert.ToInt32(Session["level"].ToString()) < 2)
            {
                Response.Redirect("login.aspx");
            }
        }
        catch (Exception ex)
        {
            Response.Redirect("login.aspx");
        }
    }
    protected void btnCheck_Click(object sender, EventArgs e)
    {
        try
        {
            if (userAdapter.SQIfHasUser(Convert.ToInt32(txtStuId.Text.Trim())) != 0)
            {
                Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('学号已经存在！')</script>");
                return;
            }
            if (string.IsNullOrEmpty(ddlDepart.SelectedItem.Value) || string.IsNullOrEmpty(ddlSpec.SelectedItem.Value) || string.IsNullOrEmpty(ddlClass.SelectedItem.Value))
            {
                Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('系部、专业、班级没有选择完整请重新选择！')</script>");
                return;
            }

            int specNum = Convert.ToInt32(ddlSpec.SelectedItem.Value);
            int departNum = Convert.ToInt32(ddlDepart.SelectedItem.Value);
            int classNum = Convert.ToInt32(ddlSpec.SelectedItem.Value);
            if (userAdapter.InsertUser(txtName.Text.Trim(), Convert.ToInt32(txtStuId.Text.Trim()), departNum, specNum, classNum, txtRoomNum.Text.Trim()) == 1)
            {
                Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('插入成功！')</script>");
            }
        }
        catch (Exception ex)
        {
            Page.ClientScript.RegisterStartupScript(this.GetType(), "Alert", "<script>window.alert('插入失败！')</script>");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtEmail.Text = "";
        txtName.Text = "";
        txtRoomNum.Text = "";
        txtStuId.Text = "";
    }
}
