﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Routing;
using System.Text;

namespace System.Web.Mvc
{
    public static class MikePagerHtmlExtensions
    {

        #region MikePager 分页控件

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data)
        {
            string actioinName = html.ViewContext.RouteData.GetRequiredString("action");
            return MikePager<T>(html, data, actioinName);
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, object values)
        {
            string actioinName = html.ViewContext.RouteData.GetRequiredString("action");
            return MikePager<T>(html, data, actioinName, values);
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, string action)
        {
            return MikePager<T>(html, data, action, null);
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, string action, object values)
        {
            string controllerName = html.ViewContext.RouteData.GetRequiredString("controller");
            return MikePager<T>(html, data, action, controllerName, values);
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, string action, string controller, object values)
        {
            return MikePager<T>(html, data, action, controller, new RouteValueDictionary(values));
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, RouteValueDictionary values)
        {
            string actioinName = html.ViewContext.RouteData.GetRequiredString("action");
            return MikePager<T>(html, data, actioinName, values);
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, string action, RouteValueDictionary values)
        {
            string controllerName = html.ViewContext.RouteData.GetRequiredString("controller");
            return MikePager<T>(html, data, action, controllerName, values);
        }

        public static string MikePager<T>(this HtmlHelper html, PagedList<T> data, string action, string controller, RouteValueDictionary valuedic)
        {
            int start = (data.PageIndex - 5) >= 1 ? (data.PageIndex - 5) : 1;
            int end = (data.TotalPage - start) > 9 ? start + 9 : data.TotalPage;

            RouteValueDictionary vs = valuedic == null ? new RouteValueDictionary() : valuedic;

            var builder = new StringBuilder();
            builder.AppendFormat("<div class=\"mike_mvc_pager\">");
            
            if (data.IsPreviousPage)
            {
                vs["pageIndex"] = 1;
                builder.Append(Html.LinkExtensions.ActionLink(html, "首页", action, controller, vs, null));
                builder.Append("&nbsp;");//add by 51aspx
                vs["pageIndex"] = data.PageIndex - 1;
                builder.Append(Html.LinkExtensions.ActionLink(html, "上一页", action, controller, vs, null));
                builder.Append("&nbsp;");//add by 51aspx

            }

            for (int i = start; i <= end; i++) //前后各显示5个数字页码
            {
                vs["pageIndex"] = i;
                if (i == data.PageIndex)
                {
                    builder.Append("<font class='thispagethis'>" + i.ToString() + "</font>&nbsp;");
                }
                else
                {
                    builder.Append("&nbsp;");//add by 51aspx

                    builder.Append(Html.LinkExtensions.ActionLink(html, i.ToString(), action, controller, vs, null));
                }
            }

            if (data.IsNextPage)
            {
                builder.Append("&nbsp;");//add by 51aspx

                vs["pageIndex"] = data.PageIndex + 1;
                builder.Append(Html.LinkExtensions.ActionLink(html, "下一页", action, controller, vs, null));
                builder.Append("&nbsp;");//add by 51aspx


                vs["pageIndex"] = data.TotalPage;
                builder.Append(Html.LinkExtensions.ActionLink(html, "末页", action, controller, vs, null));


            }
            builder.Append("&nbsp;每页" + data.PageSize + "条/共" + data.TotalCount + "条 第" + data.PageIndex + "页/共" + data.TotalPage + "页 </div>");
            return builder.ToString();
        }
        #endregion

    }
}
