﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DAL;
using BLL;

namespace Web.Controllers
{
    [HandleError]
    public class HomeController : Controller
    {
        public ActionResult Index(int? pageIndex)
        {
            ViewData["Message"] = "Welcome to ASP.NET MVC! 51AspX";

            Products _Proeduct = new Products();

            ViewData["Product"] = _Proeduct.AllPaged(pageIndex, false);

            return View();
        }

        public ActionResult Edit(int? id)
        {

            Products _Proeduct = new Products();

            var model = new Product();

            if (id != null)
            {
                model = _Proeduct.Get(id.Value);
            }

            return View(model);
        }


        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Edit(int? id, Product _Product)
        {
            Edit(id);
            try
            {
                if (id != null)
                {
                    Products item = new Products();
                    item.Update(id.Value, _Product);
                }
                else
                {
                    UpdateModel(_Product);
                    Products item = new Products();
                    item.Insert(_Product);
                }

            }
            catch (Exception e)
            {
                ModelState.AddModelError("_FORM", e.Message);
                return View();
            }

            return RedirectToAction("Index");
        }

        public ActionResult Delete(int id)
        {
            Products item = new Products();
            item.Delete(id);
            return RedirectToAction("Index");
        }

        public ActionResult About()
        {
            return View();
        }
    }
}
