﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Data.OleDb;
using System.Reflection;
namespace Common
{
    /// <summary>
    /// 数据库处理类
    /// </summary>
    public class DbHelper
    {
        /// <summary>
        /// 取得连接字符串
        /// </summary>
        /// <returns>连接字符串</returns>
        public static string ConStr
        {
            get
            {
                return ConfigurationManager.ConnectionStrings["con"].ConnectionString;
            }
        }
        /// <summary>
        /// 得到一个与默认数据库的连接
        /// </summary>
        /// <returns>数据库连接</returns>
        public OleDbConnection GetConnection()
        {
            OleDbConnection con;
            try
            {
                con = new OleDbConnection(DbHelper.ConStr);
                con.Open();
            }
            catch (OleDbException e)
            {
                throw new Exception("数据库连接失败" + e.Message);
            }
            return con;
        }
        /// <summary>
        /// 执行SQL
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public object ExecuteScalar(string sql)
        {
            object res;
            try
            {
                OleDbConnection con = GetConnection();
                OleDbCommand com = new OleDbCommand();
                com.Connection = con;
                com.CommandText = sql;
                res = com.ExecuteScalar();
                com.Dispose();
                con.Dispose();
                return res;
            }
            catch (OleDbException e)
            {
                throw new Exception("sql语句执行失败/n" + e.Message);
            }
        }
        public int ExecuteSqlNonQuery(string sql)
        {
            try
            {
                OleDbConnection con = GetConnection();
                OleDbCommand com = new OleDbCommand();
                com.Connection = con;
                com.CommandText = sql;
                int nrow = com.ExecuteNonQuery();
                com.Dispose();
                con.Dispose();
                return nrow;
            }
            catch (OleDbException e)
            {
                throw new Exception(e.Message);
            }
        }
        /// <summary>
        /// 执行SQL
        /// </summary>
        /// <param name="sql"></param>
        /// <returns>数据表</returns>
        public DataTable ExecuteSql(string sql)
        {
            try
            {
                OleDbConnection con = GetConnection();
                OleDbCommand com = new OleDbCommand();
                com.Connection = con;
                com.CommandText = sql;
                OleDbDataAdapter da = new OleDbDataAdapter(com);
                DataTable dt = new DataTable("bulletin");
                da.Fill(dt);
                da.Dispose();
                com.Dispose();
                con.Dispose();
                return dt;
            }
            catch (OleDbException e)
            {
                throw e;
            }
        }
        /// <summary>
        /// 执行SQL
        /// </summary>
        /// <param name="sql"></param>
        /// <returns>数据表</returns>
        public DataSet ExecuteDataSet(string sql)
        {
            try
            {
                OleDbConnection con = GetConnection();
                OleDbCommand com = new OleDbCommand();
                com.Connection = con;
                com.CommandText = sql;
                OleDbDataAdapter da = new OleDbDataAdapter(com);
                DataSet ds = new DataSet();
                da.Fill(ds);
                da.Dispose();
                com.Dispose();
                con.Dispose();
                return ds;
            }
            catch (OleDbException e)
            {
                throw e;
            }
        }
    }
}