﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Xml;
using Common;
using System.Text.RegularExpressions;
namespace hqgl.dept
{
    /// <summary>
    /// dept 的摘要说明
    /// </summary>
    public class deptchuli
    {
        #region 下面的是用来生成部门树的
        public XmlDataSource MakeTreeDate(string tpage, string target)
        {
            XmlDocument xd = MakeDepTree(tpage, target);
            XmlDataSource xds = new XmlDataSource();
            xds.EnableCaching = false;
            xds.CacheDuration = 1;
            xds.Data = xd.InnerXml;
            xds.DataBind();
            return xds;
        }
        public XmlDocument MakeDepTree(string tpage,string target)
        {
            XmlDocument xdoc = new XmlDocument();
            xdoc.AppendChild(xdoc.CreateElement("root"));
            XmlNode root = xdoc.SelectSingleNode("root");
            XmlElement xe=(XmlElement)root;
            xe.SetAttribute("name", "网络智能管理系统1.0");
            xe.SetAttribute("id", "");
            string sql = "select * from department order by dept_no asc";
            DbHelper db = new DbHelper();
            DataTable dt = db.ExecuteSql(sql);
            AddChiled("0", ref dt, ref root, xdoc,tpage,target);
            return xdoc;
        }
        public void AddChiled(string id, ref DataTable dt, ref XmlNode root, XmlDocument xdoc,string tpage,string target)
        {
            DataRow[] drs = dt.Select("dept_parent=" + id);
            if (drs.Length == 0)
                return;
            foreach (DataRow dr in drs)
            {
                XmlElement xe = xdoc.CreateElement("Node");
                xe.SetAttribute("id", tpage+dr["dept_id"].ToString());
                xe.SetAttribute("name", dr["dept_name"].ToString());
                xe.SetAttribute("target", target);
                root.AppendChild(xe);
            }
            foreach (XmlNode xn in root.ChildNodes)
            {
                XmlElement cxe = (XmlElement)xn;
                string cid = cxe.GetAttribute("id").ToString();
                Regex rex = new Regex(@"(?<=\?id\=)\d+", RegexOptions.IgnoreCase);
                if(rex.IsMatch(cid))
                    cid=rex.Match(cid).Value;
                XmlNode cxn = xn;
                AddChiled(cid, ref dt, ref cxn, xdoc,tpage,target);
            }
        }
        public ListItemCollection Make_DropList(XmlNode xn, string flag)
        {
            ListItemCollection lic = new ListItemCollection();
            if (xn.ChildNodes.Count == 0)
                return lic;
            foreach (XmlNode cxn in xn.ChildNodes)
            {
                XmlElement xe = (XmlElement)cxn;
                string id = xe.GetAttribute("id").ToString();
                string name = flag + xe.GetAttribute("name").ToString();
                ListItem item = new ListItem(name, id);
                lic.Add(item);
                string cflag;
                if (flag == "|─")
                    cflag = flag.Replace("|─", "|　");
                else
                    cflag = flag.Replace("　|─", "　　　");
                ListItemCollection clic = Make_DropList(cxn, cflag + "|─");
                foreach (ListItem lit in clic)
                    lic.Add(lit);
            }
            return lic;
        }
        public ListItemCollection Make_DropList()
        {
            deptchuli dpc = new deptchuli();
            XmlDocument xdoc = dpc.MakeDepTree("","");
            XmlNode root = xdoc.SelectSingleNode("root");
            string flag = "|─";
            return Make_DropList(root, flag);
        }
        #endregion
        public int Dept_Add(deptinfo dinfo)
        {
            string sql = @"insert into department(dept_no,dept_name,tel_no,fax_no,dept_parent,dept_func) 
                            values('#dept_no#','#dept_name#','#tel_no#','#fax_no#',#dept_parent#,'#dept_func#')";
            sql = sql.Replace("#dept_no#", dinfo.dept_no);
            sql = sql.Replace("#dept_name#", dinfo.dept_name);
            sql = sql.Replace("#tel_no#", dinfo.tel_no);
            sql = sql.Replace("#fax_no#", dinfo.fax_no);
            sql = sql.Replace("#dept_parent#", dinfo.DEPT_PARENT);
            sql = sql.Replace("#dept_func#", dinfo.DEPT_FUNC);
            DbHelper db = new DbHelper();
            try
            {
                db.ExecuteSqlNonQuery(sql);
                return 1;
            }
            catch
            {
                return -11;
            }
        }

        public deptinfo Dept_GetByID(string id)
        {
            deptinfo dinfo = new deptinfo();
            string sql = "select * from department where dept_id=#dept_id#";
            sql = sql.Replace("#dept_id#", id);
            DbHelper db = new DbHelper();
            DataTable dt = db.ExecuteSql(sql);
            if (dt.Rows.Count > 0)
            {
                DataRow dr = dt.Rows[0];
                dinfo.DEPT_FUNC = dr["dept_func"].ToString();
                dinfo.dept_id = dr["dept_id"].ToString();
                dinfo.dept_name = dr["dept_name"].ToString();
                dinfo.dept_no = dr["dept_no"].ToString();
                dinfo.DEPT_PARENT = dr["dept_parent"].ToString();
                dinfo.fax_no = dr["fax_no"].ToString();
                dinfo.tel_no = dr["tel_no"].ToString();
                return dinfo;
            }
            else
                return null;
           
        }
        public int Dept_Edit(deptinfo dinfo)
        {
            string sql = @"update department set dept_no='#dept_no#',dept_name='#dept_name#',
                            tel_no='#tel_no#',fax_no='#fax_no#',dept_parent=#dept_parent#,dept_func='#dept_func#' 
                                where dept_id=#dept_id#";
            sql = sql.Replace("#dept_no#", dinfo.dept_no);
            sql = sql.Replace("#dept_name#", dinfo.dept_name);
            sql = sql.Replace("#tel_no#", dinfo.tel_no);
            sql = sql.Replace("#fax_no#", dinfo.fax_no);
            sql = sql.Replace("#dept_parent#", dinfo.DEPT_PARENT);
            sql = sql.Replace("#dept_func#", dinfo.DEPT_FUNC);
            sql = sql.Replace("#dept_id#", dinfo.dept_id);
            DbHelper db = new DbHelper();
            try
            {
                db.ExecuteSqlNonQuery(sql);
                return 1;

            }
            catch
            {
                return -12;
            }
        }
        public int Dept_Delete(string id)
        {
            string sql = "delete from department where dept_id=#dept_id#";
            sql = sql.Replace("#dept_id#", id);
            DbHelper db = new DbHelper();
            try
            {
                db.ExecuteSqlNonQuery(sql);
                return 1;
            }
            catch
            {
                return -13;
            }
        }
        public string dept_getfunc(string id)
        {
            string sql = "select func_id_str from user_priv where user_priv=#user_priv#";
            sql = sql.Replace("#user_priv#", id);
            DbHelper dbh = new DbHelper();
            object o = dbh.ExecuteScalar(sql);
            return o.ToString();
        }
    }
    public class deptinfo
    {
        public string dept_id;
        public string dept_no = "";
        public string dept_name = "";
        public string tel_no = "";
        public string fax_no = "";
        public string DEPT_PARENT = "0";
        public string DEPT_FUNC = "";
    }
}