﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;
using Common;
using System.Text.RegularExpressions;
using System.Data.SqlClient;
namespace hqgl.email
{
    /// <summary>
    /// email 的摘要说明
    /// </summary>
    public class emailchuli
    {

        public DataTable Email_GetAttachment(string email_id)
        {
            string sql = "select ATTACHMENT_NAME,ATTACHMENT_ID  from email where EMAIL_ID=###";
            sql = sql.Replace("###", email_id);
            DbHelper db=new DbHelper();
            DataTable dt= db.ExecuteSql(sql);
            if (dt != null)
            {
                string lst = dt.Rows[0][0].ToString();
                string ilst = dt.Rows[0][1].ToString();
                dt.Rows.Clear();
                DataRow dr = dt.NewRow();
                Regex rex = new Regex(@"((?<=,)|(?<=\b))[^,]+?((?=,)|(?=$))", RegexOptions.IgnoreCase);
                foreach (Match item in rex.Matches(lst))
                {
                    dr[0] = item.ToString();
                    dr[1] = ilst;
                    dt.Rows.Add(dr);
                    dr = dt.NewRow();
                }
            }
            return dt;
        }
        public int Save_Attachment(byte[] body,string filename,string email_id,out string dir,out string msg)
        {
            string edir="";
            if (!string.IsNullOrEmpty(email_id))
                if (Email_GetDir(email_id, out edir) != 1)
                {
                    dir = "";
                    msg = "";
                    return -7;
                }
            int len = body.Length;
            if (len < 1024000 & len > 0)
            {
                string sysdir = HttpContext.Current.Server.MapPath("~\\attachment\\");
                if (string.IsNullOrEmpty(edir))
                {
                    dir = DateTime.Now.ToString();
                    Regex rex = new Regex(@"[-|:| ]", RegexOptions.IgnoreCase);
                    dir = rex.Replace(dir, "");
                }
                else
                    dir = edir;
                Directory.CreateDirectory(sysdir + dir);
                FileStream fs=File.Create(sysdir + dir + @"\" + filename);
                fs.Write(body, 0, len);
                fs.Close();
                msg = "完成";
                return 1;
            }
            else
            {
                dir = "";
                msg = "附件只允许1M以内";
                return -7;
            }
        }
        public int Email_GetDir(string email_id,out string dir)
        {
            string sql = "select ATTACHMENT_ID  from email where EMAIL_ID=###";
            sql = sql.Replace("###", email_id);
            DbHelper db = new DbHelper();
            object dr = db.ExecuteScalar(sql);
            if (dr != null)
            {
                dir = dr.ToString();
                return 1;
            }
            else
            {
                dir = "temp";
                return -10;
            }
        }
        public int Email_GetAt(string email_id, out string files)
        {
            string sql = "select ATTACHMENT_NAME  from email where EMAIL_ID=###";
            sql = sql.Replace("###", email_id);
            DbHelper db = new DbHelper();
            object dr = db.ExecuteScalar(sql);
            if (dr != null)
            {
                files = dr.ToString();
                return 1;
            }
            else
            {
                files = "";
                return -10;
            }
        }
        /// <summary>
        /// 新建EMAIL的函数
        /// </summary>
        /// <param name="einfo"></param>
        /// <returns></returns>
        public int Email_Add(emailinfo einfo/*,out string email_id*/)
        {

            string sql = @"insert into email(from_id,to_id,subject,content,send_time,read_flag,send_flag,delete_flag)  values(
                        '#from_id#','#to_id#','#subject#','#content#',#send_time#,'#read_flag#','#send_flag#','#delete_flag#')";
            sql=sql.Replace("#from_id#",einfo.FROM_ID);
            sql=sql.Replace("#to_id#",einfo.TO_ID);
            //sql=sql.Replace("#copy_to_id#",einfo.COPY_TO_ID);
            sql=sql.Replace("#subject#",einfo.SUBJECT);
            sql=sql.Replace("#content#",einfo.CONTENT);
            sql=sql.Replace("#send_time#",einfo.SEND_TIME);
            //sql=sql.Replace("#attachment_id#",einfo.ATTACHMENT_ID);
            //sql=sql.Replace("#attachment_name#",einfo.ATTACHMENT_NAME);
            sql=sql.Replace("#read_flag#",einfo.READ_FLAG);
            sql=sql.Replace("#send_flag#",einfo.SEND_FLAG);
            sql=sql.Replace("#delete_flag#",einfo.DELETE_FLAG);
            //sql=sql.Replace("#sms_remind#",einfo.SMS_REMIND);
            //sql=sql.Replace("#important#",einfo.IMPORTANT);
            DbHelper db=new DbHelper();
            db.ExecuteSqlNonQuery(sql);
            object e_id = GetNew();
            if (e_id != null)
            {
                //email_id = e_id.ToString();
                return 1;
            }
            else
            {
                //email_id = null;
                return -8;
            }
        }
        protected object GetNew()
        {
            DbHelper db = new DbHelper();
            string sql = "select * from tmp";
            object res = db.ExecuteScalar(sql);
            sql = "update tmp set a_id=-1";
            db.ExecuteSqlNonQuery(sql);
            return res;
        }
        /// <summary>
        /// 更新EMAIL的函数
        /// </summary>
        /// <param name="einfo"></param>
        /// <returns></returns>
        public int Email_Edit(emailinfo einfo)
        {

            string sql = @"update email set from_id='#from_id#',to_id='#to_id#',copy_to_id='#copy_to_id#',
                            subject='#subject#',content='#content#',send_time=#send_time#,attachment_id='#attachment_id#',
                            attachment_name='#attachment_name#',read_flag='#read_flag#',send_flag='#send_flag#',
                            delete_flag='#delete_flag#',sms_remind='#sms_remind#',important='#important#'";
            sql = sql.Replace("#from_id#", einfo.FROM_ID);
            sql = sql.Replace("#to_id#", einfo.TO_ID);
            sql = sql.Replace("#copy_to_id#", einfo.COPY_TO_ID);
            sql = sql.Replace("#subject#", einfo.SUBJECT);
            sql = sql.Replace("#content#", einfo.CONTENT);
            sql = sql.Replace("#send_time#", einfo.SEND_TIME);
            sql = sql.Replace("#attachment_id#", einfo.ATTACHMENT_ID);
            sql = sql.Replace("#attachment_name#", einfo.ATTACHMENT_NAME);
            sql = sql.Replace("#read_flag#", einfo.READ_FLAG);
            sql = sql.Replace("#send_flag#", einfo.SEND_FLAG);
            sql = sql.Replace("#delete_flag#", einfo.DELETE_FLAG);
            sql = sql.Replace("#sms_remind#", einfo.SMS_REMIND);
            sql = sql.Replace("#important#", einfo.IMPORTANT);
            DbHelper db = new DbHelper();
            try
            {
                db.ExecuteSqlNonQuery(sql);
                return 1;
            }
            catch
            {
                return -9;
            }
        }
    }
    public class emailinfo
    {
        public string EMAIL_ID;
        public string FROM_ID;
        public string TO_ID;
        public string COPY_TO_ID = "";
        public string SUBJECT = "主题";
        public string CONTENT = "";
        public string SEND_TIME = "1988-12-28";
        public string ATTACHMENT_ID = "";
        public string ATTACHMENT_NAME = "";
        public string READ_FLAG = "";
        public string SEND_FLAG = "";
        public string DELETE_FLAG = "";
        public string SMS_REMIND = "";
        public string IMPORTANT = "";
    }
}