﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using Common;
using System.Text;
using WebMessageBox;
public partial class general_role_MakeRole : System.Web.UI.Page
{
    public string rolename = "", func = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        Response.Cache.SetCacheability(HttpCacheability.NoCache);
        Response.Cache.SetExpires(DateTime.Now.AddHours(-1));
        string priv = Request.QueryString["id"];
        if (string.IsNullOrEmpty(priv))
        {
            this.ClientScript.RegisterStartupScript(this.GetType(), "start", "history.back();alert('无效参数')", true);
        }
        else
        {
            func = GetRole(priv, out rolename);
            MakeLists(func);
        }
    }
    public string GetRole(string priv, out string rn)
    {
        string sql = "SELECT [PRIV_NAME],[func_id_str] FROM [user_priv] where [user_priv]=#user_priv# ";
        sql = sql.Replace("#user_priv#", priv);
        DbHelper dbh = new DbHelper();
        DataTable dt = dbh.ExecuteSql(sql);
        if (dt.Rows.Count > 0)
            rn = dt.Rows[0]["priv_name"].ToString();
        else
        {
            this.ClientScript.RegisterStartupScript(this.GetType(), "start", "history.back();alert('无效参数')", true);
            rn = "";
        }
        return dt.Rows[0]["func_id_str"].ToString();
    }
    public void MakeLists(string func)
    {
        XmlDocument xdoc = new XmlDocument();
        xdoc.Load(Server.MapPath("~/web.sitemap"));
        XmlNodeList xln = xdoc.LastChild.LastChild.ChildNodes;
        foreach (XmlNode xn in xln)
        {
            XmlDataSource xds = new XmlDataSource();
            xds.EnableCaching = false;
            xds.Data = xn.OuterXml;
            TreeView tmptreeview = new TreeView();
            tmptreeview.ExpandDepth = -1;
            tmptreeview.ShowLines = true;
            TreeNodeBinding tnb = new TreeNodeBinding();
            tnb.DataMember = "SiteMapNode";
            tnb.ImageUrlField = "description";
            tnb.ShowCheckBox = true;
            tnb.TextField = "title";
            tnb.ValueField = "index";
            tnb.SelectAction = TreeNodeSelectAction.Expand;
            tmptreeview.TreeNodeDataBound += new TreeNodeEventHandler(tmptreeview_DataBound);
            tmptreeview.DataBindings.Add(tnb);
            tmptreeview.CssClass = "selecttree";
            tmptreeview.DataSource = xds;
            tmptreeview.DataBind();
            tmptreeview.EnableViewState = false;
            Panel1.Controls.Add(tmptreeview);
        }
    }
    void tmptreeview_DataBound(object sender, TreeNodeEventArgs e)
    {
        func = "," + func + ",";
        XmlNode dr = (XmlNode)e.Node.DataItem;
        string nowindex = dr.Attributes["index"].Value;
        string reg = "(?<=,)[^.]?###(?=[^.])(?=,)?";
        reg = reg.Replace("###", nowindex);
        System.Text.RegularExpressions.Regex regx = new System.Text.RegularExpressions.Regex(reg);
        if (regx.IsMatch(func))
            e.Node.Checked = true;
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Panel1.Controls.Count; i++)
        {
            TreeView tr = Panel1.Controls[i] as TreeView;
            if (tr == null)
                continue;
            sb.Append(GetSelect(tr.Nodes));
        }
        string mm = sb.ToString();
        if (mm.Length > 0)
            mm = mm.Substring(0, mm.Length - 1);
        string sql = "update [user_priv] set [func_id_str]='#function#' where  [user_priv]=#user_priv#";
        sql = sql.Replace("#user_priv#", Request.QueryString["id"]);
        sql = sql.Replace("#function#", mm);
        DbHelper dbh = new DbHelper();
        dbh.ExecuteSqlNonQuery(sql);
        MessageBox.Show("修改成功", "default.aspx");
    }
    public string GetSelect(TreeNodeCollection tns)
    {
        StringBuilder sb = new StringBuilder();
        foreach (TreeNode tn in tns)
        {
            if (tn.Checked)
                sb.Append(tn.Value + ",");
            if (tn.ChildNodes.Count > 0)
                sb.Append(GetSelect(tn.ChildNodes));
        }
        return sb.ToString();
    }
}
