﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using GDev.PopupBox;
using System.Windows.Media.Imaging;
using GDev.PopupBox.Effects;

namespace SilverlightApplication1
{
    public partial class Page : UserControl
    {
        public Page()
        {
            InitializeComponent();
        }

        private Effect GetEffect(FrameworkElement target)
        {
            switch ((string)((ComboBoxItem)Effects.SelectedItem).Tag)
            {
                case "NoEffect":
                    return Effect.NoEffect(target);
                case "Fade":
                    return Effect.Fade(target);
                case "Zoom":
                    return Effect.Zoom(target);
                default:
                    return Effect.NoEffect(target);
            }
        }

        private void OpenBox_Click(object sender, RoutedEventArgs e)
        {
            PopupService service = PopupService.GetServiceFor(LayoutRoot);
            BoxPage box = service.GetBoxPage(
                new MyControl(), //显示的控件
                Title.Text, //标题
                true, //是否可以拖动
                true //是否显示关闭图标
            );
            box.Effect = GetEffect(box);
            box.ShowComplete += new EventHandler(Box_ShowComplete);
            box.CloseComplete += new EventHandler(Box_CloseComplete);
            box.Show();
        }

        private void Box_CloseComplete(object sender, EventArgs e)
        {
            MessageText.Text = "关闭了窗口";
        }

        private void Box_ShowComplete(object sender, EventArgs e)
        {
            MessageText.Text = "打开了新窗口";
        }

        private void Box_ButtonClick(object sender, EventArgs e)
        {
            MessageText.Text = "你点击了：" + ((MessagePage)sender).Result;
        }

        private void OpenModalBox_Click(object sender, RoutedEventArgs e)
        {
            PopupService service = PopupService.GetServiceFor(LayoutRoot);
            BoxPage box = service.GetBoxPage(
                new MyControl(),
                Title.Text,
                true,
                true
            );
            box.Effect = GetEffect(box);
            box.ShowComplete += new EventHandler(Box_ShowComplete);
            box.CloseComplete += new EventHandler(Box_CloseComplete);
            box.ShowAsModal();
        }

        private void OpenMessage_Click(object sender, RoutedEventArgs e)
        {
            PopupService service = PopupService.GetServiceFor(LayoutRoot);
            MessagePage box = service.GetMessagePage(
                Message.Text,
                Title.Text,
                true,
                GetButtonType(),
                GetIcon()
            );
            box.Effect = GetEffect(box);
            box.ShowComplete += new EventHandler(Box_ShowComplete);
            box.ButtonClick += new EventHandler(Box_ButtonClick);
            box.Show();
        }

        private void OpenModalMessage_Click(object sender, RoutedEventArgs e)
        {
            PopupService service = PopupService.GetServiceFor(LayoutRoot);
            MessagePage box = service.GetMessagePage(
                Message.Text,
                Title.Text,
                true,
                GetButtonType(),
                GetIcon()
            );
            box.Effect = GetEffect(box);
            box.ShowComplete += new EventHandler(Box_ShowComplete);
            box.ButtonClick += new EventHandler(Box_ButtonClick);
            box.ShowAsModal();
        }

        private MessageBoxIcon GetIcon()
        {
            switch ((string)((ComboBoxItem)Icon.SelectedItem).Tag)
            {
                case "No":
                    return null;
                case "Warn":
                    return MessageBoxIcon.Warn;
                case "Caution":
                    return MessageBoxIcon.Caution;
                case "Error":
                    return MessageBoxIcon.Error;
                case "Information":
                    return MessageBoxIcon.Information;
                case "Question":
                    return MessageBoxIcon.Question;
                default:
                    return null;
            }
        }

        private MessageBoxButtonType GetButtonType()
        {
            string type = (string)((ComboBoxItem)ButtonType.SelectedItem).Tag;
            return (MessageBoxButtonType)Enum.Parse(
                typeof(MessageBoxButtonType),
                type,
                true
            );
        }
    }
}
