﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace GDev.PopupBox
{
    public class DragService
    {
        #region 属性

        private readonly IPopupBox m_Box;

        protected virtual IPopupBox PopupBox
        {
            get
            {
                return m_Box;
            }
        }

        #endregion

        #region 构造

        public DragService(IPopupBox popupBox)
        {
            m_Box = popupBox;
        }

        #endregion

        public void EnableDrag()
        {
            PopupBox.DragMouseCaptureArea.MouseLeftButtonDown +=
                new MouseButtonEventHandler(Drag_MouseLeftButtonDown);
            PopupBox.DragMouseCaptureArea.MouseMove +=
                new MouseEventHandler(Drag_MouseMove);
            PopupBox.DragMouseCaptureArea.MouseLeftButtonUp +=
                new MouseButtonEventHandler(Drag_MouseLeftButtonUp);
        }

        private void Drag_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            //开始拖动
            PopupBox.IsDragging = true;

            //设定鼠标位置
            PopupBox.LastDragPosition = e.GetPosition(PopupBox.Mask.MaskPanel);

            //锁定鼠标
            PopupBox.DragMouseCaptureArea.CaptureMouse();
        }

        private void Drag_MouseMove(object sender, MouseEventArgs e)
        {
            if (PopupBox.IsDragging)
            {
                Point currentPosition = e.GetPosition(PopupBox.Mask.MaskPanel);
                //移动
                MoveElement(
                    PopupBox.Element,
                    PopupBox.LastDragPosition,
                    currentPosition
                );
                PopupBox.LastDragPosition = currentPosition;
            }
        }

        private void Drag_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (PopupBox.IsDragging)
            {
                //停止拖动
                PopupBox.IsDragging = false;

                //释放鼠标
                PopupBox.DragMouseCaptureArea.ReleaseMouseCapture();

                //移动
                MoveElement(
                    PopupBox.Element,
                    PopupBox.LastDragPosition,
                    e.GetPosition(PopupBox.Mask.MaskPanel)
                );
            }
        }

        private static void MoveElement(FrameworkElement element, Point lastPosition, Point currentPosition)
        {
            //计算移动距离
            double xDelta = currentPosition.X - lastPosition.X;
            double yDelta = currentPosition.Y - lastPosition.Y;

            //移动
            double left = Canvas.GetLeft(element) + xDelta;
            double top = Canvas.GetTop(element) + yDelta;
            Canvas.SetLeft(element, left);
            Canvas.SetTop(element, top);
        }
    }
}
