﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using GDev.PopupBox.Effects;

namespace GDev.PopupBox
{
    public abstract class Effect
    {
        #region 属性

        private readonly FrameworkElement m_Target;

        protected virtual FrameworkElement Target
        {
            get
            {
                return m_Target;
            }
        }

        #endregion

        #region 构造

        public Effect(FrameworkElement target)
        {
            m_Target = target;
        }

        #endregion

        #region 抽象方法

        public abstract void PerformInEffect();

        public abstract void PerformOutEffect();

        #endregion

        #region 事件

        public event EventHandler Complete;

        protected virtual void OnComplete(EventArgs e)
        {
            EventHandler handler = Complete;
            if (handler != null)
            {
                handler(this, e);
            }
        }

        #endregion

        #region 静态获取实例

        public static Effect NoEffect(FrameworkElement target)
        {
            return new NoEffect(target);
        }

        public static Effect Fade(FrameworkElement target)
        {
            return new FadeEffect(target);
        }

        public static Effect Zoom(FrameworkElement target)
        {
            return new ZoomEffect(target);
        }

        #endregion
    }
}
