﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace GDev.PopupBox.Effects
{
    public class FadeEffect : Effect
    {
        #region 重写方法

        public override void PerformInEffect()
        {
            DoubleAnimation animationForOpacity = new DoubleAnimation();
            Storyboard.SetTarget(animationForOpacity, Target);
            Storyboard.SetTargetProperty(
                animationForOpacity, new PropertyPath(FrameworkElement.OpacityProperty));
            animationForOpacity.From = 0;
            animationForOpacity.To = 1;

            Storyboard storyBoard = new Storyboard();
            storyBoard.RepeatBehavior = new RepeatBehavior(1);
            storyBoard.Children.Add(animationForOpacity);

            storyBoard.Completed += new EventHandler(StoryBoard_Completed);

            storyBoard.Begin();
        }

        public override void PerformOutEffect()
        {
            DoubleAnimation animationForOpacity = new DoubleAnimation();
            Storyboard.SetTarget(animationForOpacity, Target);
            Storyboard.SetTargetProperty(
                animationForOpacity, new PropertyPath(FrameworkElement.OpacityProperty));
            animationForOpacity.From = 1;
            animationForOpacity.To = 0;

            Storyboard storyBoard = new Storyboard();
            storyBoard.RepeatBehavior = new RepeatBehavior(1);
            storyBoard.Children.Add(animationForOpacity);

            storyBoard.Completed += new EventHandler(StoryBoard_Completed);

            storyBoard.Begin();
        }

        #endregion

        #region 事件方法

        private void StoryBoard_Completed(object sender, EventArgs e)
        {
            OnComplete(EventArgs.Empty);
        }

        #endregion

        #region 构造

        public FadeEffect(FrameworkElement target) : base(target)
        {
        }

        #endregion
    }
}
