﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace GDev.PopupBox.Effects
{
    public class ZoomEffect : Effect
    {
        #region 重写方法

        public override void PerformInEffect()
        {
            DoubleAnimation animationForWidth = new DoubleAnimation();
            Storyboard.SetTarget(animationForWidth, Target);
            Storyboard.SetTargetProperty(
                animationForWidth, new PropertyPath(FrameworkElement.WidthProperty));
            animationForWidth.From = 0;
            animationForWidth.To = Target.ActualWidth;

            DoubleAnimation animationForHeight = new DoubleAnimation();
            Storyboard.SetTarget(animationForHeight, Target);
            Storyboard.SetTargetProperty(
                animationForHeight, new PropertyPath(FrameworkElement.HeightProperty));
            animationForHeight.From = 0;
            animationForHeight.To = Target.ActualHeight;

            Storyboard storyBoard = new Storyboard();
            storyBoard.RepeatBehavior = new RepeatBehavior(1);
            storyBoard.Children.Add(animationForWidth);
            storyBoard.Children.Add(animationForHeight);

            storyBoard.Completed += new EventHandler(StoryBoard_Completed);

            storyBoard.Begin();
        }

        public override void PerformOutEffect()
        {
            DoubleAnimation animationForWidth = new DoubleAnimation();
            Storyboard.SetTarget(animationForWidth, Target);
            Storyboard.SetTargetProperty(
                animationForWidth, new PropertyPath(FrameworkElement.WidthProperty));
            animationForWidth.From = Target.ActualWidth;
            animationForWidth.To = 0;

            DoubleAnimation animationForHeight = new DoubleAnimation();
            Storyboard.SetTarget(animationForHeight, Target);
            Storyboard.SetTargetProperty(
                animationForHeight, new PropertyPath(FrameworkElement.HeightProperty));
            animationForHeight.From = Target.ActualHeight;
            animationForHeight.To = 0;

            Storyboard storyBoard = new Storyboard();
            storyBoard.RepeatBehavior = new RepeatBehavior(1);
            storyBoard.Children.Add(animationForWidth);
            storyBoard.Children.Add(animationForHeight);

            storyBoard.Completed += new EventHandler(StoryBoard_Completed);

            storyBoard.Begin();
        }

        #endregion

        #region 事件方法

        private void StoryBoard_Completed(object sender, EventArgs e)
        {
            OnComplete(EventArgs.Empty);
        }

        #endregion

        #region 构造

        public ZoomEffect(FrameworkElement target) : base(target)
        {
        }

        #endregion
    }
}
