﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;
//51aspx.com
namespace GDev.PopupBox
{
    public class ImageIcon : MessageBoxIcon
    {
        private readonly string m_SourceUri;

        protected virtual string SourceUri
        {
            get
            {
                return m_SourceUri;
            }
        }

        public ImageIcon(string sourceUri)
        {
            m_SourceUri = sourceUri;
        }

        public override FrameworkElement GetTitleIcon()
        {
            Image image = new Image()
            {
                Source = new BitmapImage(new Uri(SourceUri, UriKind.Relative))
            };
            return image;
        }

        public override FrameworkElement GetContentIcon()
        {
            Image image = new Image()
            {
                Source = new BitmapImage(new Uri(SourceUri, UriKind.Relative))
            };
            return image;
        }
    }
}
