﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
//该源码下载自www.51aspx.com(５１ａsｐｘ．ｃｏｍ)

namespace GDev.PopupBox
{
    public class LayoutMask
    {
        #region 属性

        private readonly Canvas m_Mask = new Canvas();

        public virtual Canvas MaskPanel
        {
            get
            {
                return m_Mask;
            }
        }

        protected virtual IEnumerable<IPopupBox> Boxes
        {
            get
            {
                return m_Mask.Children.OfType<IPopupBox>();
            }
        }

        public virtual bool IsRendered
        {
            get
            {
                return (MaskPanel.Parent != null);
            }
        }

        public int MaxZIndex
        {
            get
            {
                int zIndex = 0;
                if (m_Mask.Children.Count > 0)
                {
                    zIndex = m_Mask.Children.Select(element => Canvas.GetZIndex(element)).Max();
                }
                if (zIndex >= 30000)
                {
                    //ZIndex的最大值是30000多一些
                    //因此如果最大的ZIndex已经超过了30000，则未来很可能超过最大值
                    //处理方案是超过30000后重新排序ZIndex值
                    ReorderZIndex();
                }
                return zIndex;
            }
        }

        protected bool IsModal
        {
            get
            {
                if (MaskPanel.Children.Count == 0)
                {
                    return false;
                }
                //只要有一个弹出窗口是Modal的，则此层应该是Modal的
                return Boxes.Any(box => box.IsModal);
            }
        }

        private readonly Panel m_Owner;

        protected virtual Panel Owner
        {
            get
            {
                return m_Owner;
            }
        }

        public int BoxCount
        {
            get
            {
                return Boxes.Count();
            }
        }

        #endregion

        #region 构造

        public LayoutMask(Panel owner)
        {
            m_Owner = owner;
        }

        #endregion

        #region 方法

        public void AddBox(IPopupBox box)
        {
            box.Mask = this;
            MaskPanel.Children.Add(box.Element);

            CheckModal();

            //如果Mask中没有其他的弹出窗，则此时Mask并没有显示
            //要将Mask显示出来
            if (IsRendered == false)
            {
                RenderMask();
            }
        }

        public void RemoveBox(IPopupBox box)
        {
            box.Mask = null;
            MaskPanel.Children.Remove(box.Element);

            CheckModal();

            //如果没有子元素则从上级中移除
            if (MaskPanel.Children.Count == 0)
            {
                Owner.Children.Remove(MaskPanel);
            }
        }

        public void CenterToMask(IPopupBox box)
        {
            //计算左右距离
            double left = (box.Mask.MaskPanel.ActualWidth - box.Element.ActualWidth) / 2;
            double top = (box.Mask.MaskPanel.ActualHeight - box.Element.ActualHeight) / 2;
            Canvas.SetLeft(box.Element, left);
            Canvas.SetTop(box.Element, top);
        }

        #endregion

        #region 辅助方法

        protected virtual void RenderMask()
        {
            CheckModal();

            Owner.UpdateLayout();
            MaskPanel.Width = Owner.ActualWidth;
            MaskPanel.Height = Owner.ActualHeight;
            MaskPanel.UpdateLayout();
            Owner.Children.Add(MaskPanel);
            Canvas.SetZIndex(MaskPanel, (Int16.MaxValue - 1));
        }

        protected virtual void RemoveMask()
        {
            Owner.Children.Remove(MaskPanel);
        }

        protected virtual void CheckModal()
        {
            if (IsModal)
            {
                SolidColorBrush brush = new SolidColorBrush(Color.FromArgb(100, 255, 255, 255));
                MaskPanel.Background = brush;
            }
            else
            {
                MaskPanel.Background = null;
            }
        }

        protected virtual void ReorderZIndex()
        {
            //先将所有控件按ZIndex从小到大排序
            IEnumerable<UIElement> elements =
                m_Mask.Children.OrderBy(element => Canvas.GetZIndex(element));
            //从1开始将控件的ZIndex改变为递增序列
            int currentZIndex = 1;
            int zIndexOfLastElement = 0;
            foreach (UIElement element in elements)
            {
                //如果当前控件与上一控件的ZIndex相同，说明他们在同一层
                //则不需要递增地设置ZIndex
                //相反则需要设置ZIndex递增
                if (zIndexOfLastElement != Canvas.GetZIndex(element))
                {
                    currentZIndex++;
                }
                Canvas.SetZIndex(element, currentZIndex);
            }
        }

        #endregion
    }
}
