﻿using System.Linq;
using System.Windows;
using System.Windows.Media;

namespace DynamicGeometry
{
    public class DistanceMeasurementCreator : FigureCreator
    {
        protected override DependencyList InitExpectedDependencies()
        {
            return DependencyList.PointPoint;
        }

        protected override IFigure CreateFigure()
        {
            var result = Factory.CreateDistanceMeasurement(Drawing, FoundDependencies);
            return result;
        }

        protected override void MouseDown(object sender, System.Windows.Input.MouseButtonEventArgs e)
        {
            var underMouse = Drawing.Figures.HitTest(Coordinates(e), typeof(Segment));
            if (underMouse != null 
                && underMouse.Dependencies.Count() == 2
                && Drawing.Figures.HitTest(Coordinates(e), typeof(IPoint)) == null)
            {
                FoundDependencies = new FigureList(underMouse.Dependencies);
            }
            base.MouseDown(sender, e);
        }

        public override string Name
        {
            get { return "Distance"; }
        }

        public override string HintText
        {
            get
            {
                return "Click two points to measure distance between them, or a segment to measure its length.";
            }
        }

        public override System.Windows.Controls.Panel CreateIcon()
        {
            var builder = IconBuilder.BuildIcon();
            var polygon = builder.AddPolygon(
                new Point(0.1, 0.8),
                new Point(0.3, 1),
                new Point(1, 0.3),
                new Point(0.8, 0.1)
            );
            polygon.Fill = new SolidColorBrush(Colors.Yellow);
            polygon.Stroke = new SolidColorBrush(Colors.Black);
            builder.Line(0, 0.7, 0.7, 0);
            for (double i = 0.2; i <= 0.7; i += 0.1)
            {
                builder.Line(i, 0.9 - i, i + 0.1, 1 - i);
            }
            for (double i = 0.15; i <= 0.75; i += 0.1)
            {
                builder.Line(i, 0.9 - i, i + 0.05, 0.95 - i);
            }
            return builder.Canvas;
        }
    }
}