﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Known.DLite
{
	public class Command
	{
		public string Text { get; set; }
		public List<Parameter> Parameters { get; set; }

		public bool HasParameter
		{
			get
			{
				if (Parameters == null)
				{
					return false;
				}
				return Parameters.Count > 0;
			}
		}

		public Command() { }

		public Command(string text)
			: this(text, null)
		{
		}

		public Command(string text, List<Parameter> parameters)
		{
			Text = text;
			Parameters = parameters;
		}

		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();
			sb.AppendLine("Text=" + Text);
			if (HasParameter)
			{
				sb.AppendLine("Parameters:");
				foreach (Parameter param in Parameters)
				{
					sb.AppendLine(param.ToString());
				}
			}
			return sb.ToString();
		}
	}
}
