﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Known.DLite;
using Known.DLite.Mapping;
//5/1/a/spx
namespace WebTest
{
	[Table(Name = "ks_User")]
	public class User
	{
		private static List<User> allUsers;

		[Column(IsDbGenerated = true, IsPrimaryKey = true)]
		public int ID { get; set; }
		public string UserName { get; set; }
		[Column(IsChangeable = true)]
		public string Password { get; set; }
		[Column(IsChangeable = true)]
		public string Question { get; set; }
		[Column(IsChangeable = true)]
		public string Answer { get; set; }
		[Column(IsChangeable = true)]
		public string Email { get; set; }

		public void Add()
		{
			allUsers.Add(this);
			using (Transaction trans = new Transaction())
			{
				trans.Insert<User>(this);
				trans.SubmitChanges();
			}
		}

		public void Update()
		{
			using (Transaction trans = new Transaction())
			{
				trans.Update<User>(this);
				trans.SubmitChanges();
			}
		}

		public void Delete()
		{
			allUsers.Remove(this);
			using (Transaction trans = new Transaction())
			{
				trans.Delete<User>(this);
				trans.SubmitChanges();
			}
		}

		public static User Get(int id)
		{
			KQuery query = new KQuery();
			return query.Get<User>(id);
		}

		public static List<User> GetAll()
		{
			if (allUsers == null)
			{
				KQuery query = new KQuery();
				allUsers = query.FindAll<User>();
			}
			return allUsers;
		}
	}
}
