﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Configuration;

namespace NScontract.Manager
{
    /// <summary>
    /// AddProduct 的摘要说明。
    /// </summary>
    public partial class AddBook: System.Web.UI.Page
    {
        protected System.Web.UI.WebControls.TextBox STProPrice;
        protected System.Web.UI.WebControls.TextBox STProInfo;
        protected System.Web.UI.WebControls.Button STProd_add;
        protected System.Web.UI.WebControls.Button STProd_reset;
        protected System.Web.UI.WebControls.Label STProd_warn;
        protected System.Web.UI.WebControls.TextBox STProdName;
        protected System.Web.UI.WebControls.Label STStat;

        SqlConnection NSconn;
        private string NSmysql;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                //获得数据库连接字符串
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                NSconn = new SqlConnection(NSconnection);

                if (!IsPostBack)
                {
                    //自定义BindGrid ()方法，加载向连锁分店添加产品的信息
                    BindGrid();
                    NSconn.Open();
                    //创建查询产品信息的sql语句
                    string NSmysql1 = "select * from NSBook";
                    //创建数据库的SqlCommand对象
                    SqlCommand NScmd1 = new SqlCommand(NSmysql1, NSconn);
                    //通过调用ExecuteReader()从数据库中检索行，创建SqlDataReader实例
                    SqlDataReader NSdr1 = NScmd1.ExecuteReader();
                    //初始化产品下拉列表框
                    NS_Book.Items.Add(new ListItem("", "-1"));
                    while (NSdr1.Read())
                    {
                        //向下拉列表框添加产品名字，ID
                        NS_Book.Items.Add(new ListItem(NSdr1["NSBookName"].ToString(), NSdr1["NSBookID"].ToString()));

                    }
                    NSconn.Close();
                    NSconn.Open();
                    //创建查询连锁店信息的sql语句
                    string NSmysql = "select * from NSDep";
                    //创建数据库的SqlCommand对象
                    SqlCommand NScmd = new SqlCommand(NSmysql, NSconn);
                    //通过调用ExecuteReader()从数据库中检索行，创建SqlDataReader实例
                    SqlDataReader NSdr = NScmd.ExecuteReader();
                    //初始化连锁分店下拉列表框
                    NS_Book.Items.Add(new ListItem("", "-1"));
                    while (NSdr.Read())
                    {
                        //向下拉列表框添加连锁分店名字，ID
                        NS_Dep.Items.Add(new ListItem(NSdr["NSDepName"].ToString(), NSdr["NSDepID"].ToString()));
                    }
                    NSconn.Close();

                }
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }

        }


        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {
            this.NSmyGrid.CancelCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_cancel);
            this.NSmyGrid.EditCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_edit);
            this.NSmyGrid.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_update);
            this.NSmyGrid.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_delete);

        }
        #endregion

        //加载向连锁分店添加产品的信息
        public void BindGrid()
        {

            NSmysql = "select NSBookDe.ID,NSBookDe.NSBookID,NSDep.NSDepName,NSBookDe.NSBookName,NSBookDe.NSBookNum,NSBookDe.NSBookPrice,NSBookDe.NSBookDate,NSBookDe.NSBookSH,NSBookDe.NSBookInfo from NSBookDe,NSDep where NSBookDe.NSDepID = NSDep.NSDepID";
            SqlDataAdapter NSsda = new SqlDataAdapter(NSmysql, NSconn);
            DataSet NSds = new DataSet();
            NSsda.Fill(NSds);
            NSmyGrid.DataSource = NSds;

            NSmyGrid.DataBind();


        }
        //处理分页
        public void NSmyGrid_Page(object sender, DataGridPageChangedEventArgs e)
        {
            //获取DataGrid的当前显示页的索引
            NSmyGrid.CurrentPageIndex = e.NewPageIndex;
            BindGrid();
        }
        private void NSBook_reset_Click(object sender, System.EventArgs e)
        {
            Response.Redirect("NSAddBook.aspx");
        }

        public void NSmyGrid_cancel(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            NSmyGrid.EditItemIndex = -1;
            BindGrid();
        }

        public void NSmyGrid_delete(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            string NSstrsql = "delete from NSBookDe  where ID = @ID";
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            NScmd.Parameters.Add(new SqlParameter("@ID", SqlDbType.Int, 4));
            NScmd.Parameters["@ID"].Value = NSmyGrid.DataKeys[(int)e.Item.ItemIndex];
            NScmd.Connection.Open();
            try
            {
                NScmd.ExecuteNonQuery();
            }
            catch (SqlException)
            {

            }
            //			STmysql = "select STProDe.ID,STProd.* from STProDe,STProd,STDep where STProDe.STDepID = STDep.STDepID and STProDe.STProdID = STProd.STProdID";
            NScmd.Connection.Close();
            //			BindGrid();
            //			return ;
            Response.Redirect("NSAddBook.aspx");
        }

        public void NSmyGrid_edit(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {

        }

        public void NSmyGrid_update(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {


        }

        protected void NS_ok_Click(object sender, System.EventArgs e)
        {
            if (NS_Dep.SelectedItem.Value != "-1")
            {
                if (NS_Book.SelectedItem.Value != "-1")
                {
                    SqlCommand NScmd = new SqlCommand("insert_NSBookDe_1", NSconn);
                    NScmd.CommandType = CommandType.StoredProcedure;
                    NScmd.Parameters.Add(new SqlParameter("@NSBookID", SqlDbType.Int, 4));
                    NScmd.Parameters.Add(new SqlParameter("@NSDepID", SqlDbType.Int, 4));
                    NScmd.Parameters.Add(new SqlParameter("@NSBookName", SqlDbType.VarChar, 50));
                    NScmd.Parameters.Add(new SqlParameter("@NSBookInfo", SqlDbType.VarChar, 200));
                    NScmd.Parameters.Add(new SqlParameter("@NSBookPrice", SqlDbType.Decimal, 9));
                    NScmd.Parameters.Add(new SqlParameter("@NSBookNum", SqlDbType.Decimal, 9));
                    NScmd.Parameters.Add(new SqlParameter("@NSBookDate", SqlDbType.DateTime, 8));
                    NScmd.Parameters.Add(new SqlParameter("@NSBookSH", SqlDbType.DateTime, 8));
                    NScmd.Parameters["@NSBookID"].Value = NS_Book.SelectedItem.Value;
                    NScmd.Parameters["@NSDepID"].Value = NS_Dep.SelectedItem.Value;
                    NScmd.Parameters["@NSBookName"].Value = NS_Book.SelectedItem.Text;
                    NScmd.Parameters["@NSBookInfo"].Value = NS_Book.SelectedItem.Text;
                    NScmd.Parameters["@NSBookPrice"].Value = NSDepNum.Text;
                    NScmd.Parameters["@NSBookNum"].Value = NSDepNum.Text;
                    NScmd.Parameters["@NSBookDate"].Value = NSBookDate.Text;
                    NScmd.Parameters["@NSBookSH"].Value = NSBookSH.Text;
                    NScmd.Connection.Open();
                    try
                    {
                        NScmd.ExecuteNonQuery();
                        NS_Warn.Text = "添加成功";
                        NS_Warn.Style["color"] = "red";
                        Response.Redirect("NSAddBook.aspx");
                    }
                    catch (SqlException ex)
                    {
                        string s = ex.Message;
                        NS_Warn.Text = "添加失败";
                        NS_Warn.Style["color"] = "red";
                    }
                    NScmd.Connection.Close();


                }
            }
        }

    }
}
