﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Configuration;

namespace NScontract.Manager
{
    /// <summary>
    /// AddUser 的摘要说明。
    /// </summary>
    public partial class AddUser : System.Web.UI.Page
    {
        SqlConnection NSconn;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                NSconn = new SqlConnection(NSconnection);
                NSconn.Open();
                string NSmysql1 = "select * from NSDep";
                SqlCommand NScmd1 = new SqlCommand(NSmysql1, NSconn);
                SqlDataReader NSdr1 = NScmd1.ExecuteReader();
                NSDepName.Items.Add(new ListItem("", "-1"));
                while (NSdr1.Read())
                {
                    NSDepName.Items.Add(new ListItem(NSdr1["NSDepName"].ToString(), NSdr1["NSDepID"].ToString()));
                }
                NSconn.Close();
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }

        }

        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {

        }
        #endregion

        protected void NS_ok_Click(object sender, System.EventArgs e)
        {
            if (NSNickName.Text == "")
            {
                NS_Warn.Text = "用户ID不能为空！";
                NS_Warn.Style["color"] = "red";
            }
            else if (NSUserName.Text == "")
            {
                NS_Warn.Text = "用户名字不能为空！";
                NS_Warn.Style["color"] = "red";
            }
            else
            {
                SqlCommand NScmd = new SqlCommand("insert_NSUser_1", NSconn);
                NScmd.CommandType = CommandType.StoredProcedure;
                NScmd.Parameters.Add(new SqlParameter("@NSDepID", SqlDbType.Int, 10));
                NScmd.Parameters.Add(new SqlParameter("@NSNickName", SqlDbType.VarChar, 50));
                NScmd.Parameters.Add(new SqlParameter("@NSUserName", SqlDbType.VarChar, 50));
                NScmd.Parameters.Add(new SqlParameter("@NSUserPwd", SqlDbType.VarChar, 50));
                NScmd.Parameters.Add(new SqlParameter("@NSNoAdmin", SqlDbType.Int, 4));
                NScmd.Parameters["@NSNickName"].Value = NSNickName.Text;
                NScmd.Parameters["@NSDepID"].Value = NSDepName.SelectedItem.Value; ;
                NScmd.Parameters["@NSUserName"].Value = NSUserName.Text;
                NScmd.Parameters["@NSUserPwd"].Value = NSUserName.Text;
                NScmd.Parameters["@NSNoAdmin"].Value = NSNoAdmin.SelectedItem.Value;
                NScmd.Connection.Open();
                try
                {
                    NScmd.ExecuteNonQuery();
                    Response.Redirect("NSManagerLogin.aspx");
                }
                catch (SqlException)
                {
                    NS_Warn.Text = "添加失败";
                    NS_Warn.Style["color"] = "red";
                }
                NScmd.Connection.Close();
            }
        }

        protected void NS_cancel_Click(object sender, System.EventArgs e)
        {
            Response.Redirect("AddUser.aspx");
        }


    }
}
