﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Configuration;

namespace NScontract.Manager
{
    /// <summary>
    /// ManagerStat 的摘要说明。
    /// </summary>
    public partial class ManagerStat : System.Web.UI.Page
    {
        SqlConnection NSconn;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                //获得数据库连接字符串
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                //创建数据库连接
                NSconn = new SqlConnection(NSconnection);
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }

        }

        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {

        }
        #endregion

        protected void NSDe_add_Click(object sender, System.EventArgs e)
        {
            //创建插入产品信息的sql语句
            string NSstrsql = "insert into NSBook(NSBookName) values(@NSBookName)";
            //根据sql语句，创建SqlCommand对象
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            NScmd.Parameters.Add(new SqlParameter("@NSBookName", SqlDbType.VarChar, 50));
            NScmd.Parameters["@NSBookName"].Value = NSBookName.Text;
            NScmd.Connection.Open();
            try
            {
                //执行sql语句
                NScmd.ExecuteNonQuery();
                //Label提示添加成功
                NSBook_warn.Text = "添加成功！";
                //提示信息的字体颜色
                //NSBook_warn.style["color"] = "red";
                this.NSBook_warn.ForeColor = Color.Red;
                Response.Redirect("NSManagerBook.aspx");
            }
            catch (SqlException)
            {
                //Label提示添加失败
                NSBook_warn.Text = "添加失败！";
                NSBook_warn.Style["color"] = "red";
                Response.Redirect("NSManagerAddBook.aspx");
            }
        }
    }
}
