﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Configuration;


namespace NScontract.Manager
{
    /// <summary>
    /// ManagerBook的摘要说明。
    /// </summary>
    public partial class ManagerBook : System.Web.UI.Page
    {
        SqlConnection NSconn;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                //获得数据库连接字符串
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                NSconn = new SqlConnection(NSconnection);
                if (!IsPostBack)
                {
                    //自定义BindGrid ()方法，加载产品的信息
                    BindGrid();
                }
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }
        }




        public void BindGrid()
        {
            //创建查询产品信息的sql语句
            string NSstrsql = "select NSBookID,NSBookName,NSBookImage from NSBook";
            //根据上面的sql语句，创建SqlDataAdapter的实例
            SqlDataAdapter da = new SqlDataAdapter(NSstrsql, NSconn);
            //创建DataSet的实例
            DataSet ds = new DataSet();
            //将信息填充到DataSet
            da.Fill(ds);
            //获取数据源
            NSmyGrid.DataSource = ds;
            //将信息绑定到DataGrid
            NSmyGrid.DataBind();
        }

        //处理分页
        public void NSmyGrid_Page(object sender, DataGridPageChangedEventArgs e)
        {
            //获取DataGrid的当前显示页的索引
            NSmyGrid.CurrentPageIndex = e.NewPageIndex;
            BindGrid();
        }


        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {
            this.NSmyGrid.CancelCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_cancel);
            this.NSmyGrid.EditCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_edit);
            this.NSmyGrid.UpdateCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_update);
            this.NSmyGrid.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.NSmyGrid_delete);

        }
        #endregion

        //点击取消所触发的事件
        public void NSmyGrid_cancel(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            //获取DataGrid所要编辑的项的索引为-1
            NSmyGrid.EditItemIndex = -1;
            BindGrid();
        }

        //点击删除所触发的事件
        public void NSmyGrid_delete(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            //创建删除指定ID的sql语句
            string NSstrsql = "delete from NSBook  where NSBookID = @NSBookID";
            //创建SqlCommand对象，对sql语句进行操作
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            //向SqlCommand对象添加参数
            NScmd.Parameters.Add(new SqlParameter("@NSBookID", SqlDbType.Int, 4));
            //向参数赋值
            NScmd.Parameters["@NSBookID"].Value = NSmyGrid.DataKeys[(int)e.Item.ItemIndex];
            NScmd.Connection.Open();
            try
            {
                //执行sql语句
                NScmd.ExecuteNonQuery();
            }
            catch (SqlException)
            {

            }
            NScmd.Connection.Close();
            Response.Redirect("NSManagerBook.aspx");
        }

        //点击编辑所触发的事件
        public void NSmyGrid_edit(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            //获取DataGrid所要编辑的项的索引
            NSmyGrid.EditItemIndex = (int)e.Item.ItemIndex;
            BindGrid();

        }

        //点击更新所触发的事件
        public void NSmyGrid_update(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            //根据文本框信息创建更新用户信息的sql语句
            string NSstrsql = "update NSBook set NSBookName = @NSBookName where NSBookID = @NSBookID";
            //创建SqlCommand对象，对sql语句进行操作
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            try
            {
                //向SqlCommand对象添加参数
                NScmd.Parameters.Add(new SqlParameter("@NSBookID", SqlDbType.Int, 4));
                NScmd.Parameters.Add(new SqlParameter("@NSBookName", SqlDbType.VarChar, 50));
                string stupdatetext = ((TextBox)e.Item.Cells[1].Controls[0]).Text;
                //向参数赋值
                NScmd.Parameters["@NSBookName"].Value = stupdatetext;


                NScmd.Parameters["@NSBookID"].Value = NSmyGrid.DataKeys[(int)e.Item.ItemIndex];
                NScmd.Connection.Open();
                //执行sql语句
                NScmd.ExecuteNonQuery();
                NSmyGrid.EditItemIndex = -1;
            }
            catch (SqlException ex)
            {
                throw ex;
            }
            NScmd.Connection.Close();
            BindGrid();
        }
    }
}
