﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Configuration;

namespace NScontract.Manager
{
    /// <summary>
    /// ManagerDep_Book 的摘要说明。
    /// </summary>
    public partial class ManagerDep_Book : System.Web.UI.Page
    {

        SqlConnection NSconn;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                //获得数据库连接字符串
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                NSconn = new SqlConnection(NSconnection);

                if (!IsPostBack)
                {
                    //自定义BindGrid ()方法，加载连锁店销售的信息
                    BindGrid();
                }
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }
        }

        //处理分页
        public void NSmyGrid_Page(object sender, DataGridPageChangedEventArgs e)
        {
            //获取DataGrid的当前显示页的索引
            NSmyGrid.CurrentPageIndex = e.NewPageIndex;
            BindGrid();
        }

        //加载连锁店销售的信息
        public void BindGrid()
        {
            //创建查询连锁店销售信息的sql语句
            string NSstrsql = "select NSSale.ID,NSDep.NSDepName,NSBookName,NSSale.NSSaleNum,NSSale.NSStartTime,NSSale.NSEndTime from NSSale,NSDep,NSBook where NSSale.NSBookID = NSBook.NSBookID and NSSale.NSDepID = NSDep.NSDepID";
            //创建SqlDataAdapter的实例
            SqlDataAdapter NSsda = new SqlDataAdapter(NSstrsql, NSconn);
            //创建DataSet的实例
            DataSet NSds = new DataSet();
            //将信息填充到DataSet
            NSsda.Fill(NSds);
            //获取DataGrid的数据源
            NSmyGrid.DataSource = NSds;
            //将信息绑定到DataGrid
            NSmyGrid.DataBind();

        }

        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {

        }
        #endregion



    }
}
