﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Configuration;
using System.Data.SqlClient;

namespace NScontract.Manager
{
    /// <summary>
    /// Login 的摘要说明。
    /// </summary>
    public partial class Login : System.Web.UI.Page
    {
        protected System.Web.UI.WebControls.DataGrid my;
        SqlConnection NSconn;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                NSconn = new SqlConnection(NSconnection);
                if (!IsPostBack)
                {
                    BindGrid();
                }
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }
        }

        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {

        }
        #endregion


        public void BindGrid()
        {
            string NSstrsql = "select NSUserID,NSNickName,NSUserPwd,NSUserName,NSNoAdmin from NSUser";
            SqlDataAdapter NSda = new SqlDataAdapter(NSstrsql, NSconn);
            DataSet NSds = new DataSet();
            NSda.Fill(NSds);
            NSmyGrid.DataSource = NSds;

            NSmyGrid.DataBind();

        }

        public void NSmyGrid_Page(object sender, DataGridPageChangedEventArgs e)
        {
            NSmyGrid.CurrentPageIndex = e.NewPageIndex;
            BindGrid();
        }

        public void NSmyGrid_cancel(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            NSmyGrid.EditItemIndex = -1;
            BindGrid();
        }

        public void NSmyGrid_delete(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {

            string NSstrsql = "delete from NSUser where NSUserID = @NSUserID";
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            NScmd.Parameters.Add(new SqlParameter("@NSUserID", SqlDbType.Int, 4));
            NScmd.Parameters["@NSUserID"].Value = NSmyGrid.DataKeys[(int)e.Item.ItemIndex];
            NScmd.Connection.Open();
            try
            {
                NScmd.ExecuteNonQuery();
            }
            catch (SqlException)
            {

            }
            NScmd.Connection.Close();
            BindGrid();

        }

        public void NSmyGrid_update(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {
            string NSstrsql = "update NSUser set NSNoAdmin = @NSNoAdmin ,NSNickName =@NSNickName, NSUserName = @NSUserName  where NSUserID = @NSUserID";
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            try
            {
                NScmd.Parameters.Add(new SqlParameter("@NSUserID", SqlDbType.Int, 4));
                NScmd.Parameters.Add(new SqlParameter("@NSNickName", SqlDbType.VarChar, 50));

                NScmd.Parameters.Add(new SqlParameter("@NSUserName", SqlDbType.VarChar, 50));
                NScmd.Parameters.Add(new SqlParameter("@NSNoAdmin", SqlDbType.Int, 4));
                string stupdatetext = ((TextBox)e.Item.Cells[1].Controls[0]).Text;
                NScmd.Parameters["@NSNickName"].Value = stupdatetext;
                stupdatetext = ((TextBox)e.Item.Cells[3].Controls[0]).Text;
                NScmd.Parameters["@NSUserName"].Value = stupdatetext;
                stupdatetext = ((TextBox)e.Item.Cells[4].Controls[0]).Text;
                NScmd.Parameters["@NSNoAdmin"].Value = stupdatetext;

                NScmd.Parameters["@NSUserID"].Value = NSmyGrid.DataKeys[(int)e.Item.ItemIndex];
                NScmd.Connection.Open();
                NScmd.ExecuteNonQuery();
                NSmyGrid.EditItemIndex = -1;
            }
            catch (SqlException ex)
            {
                throw ex;
            }
            NScmd.Connection.Close();
            BindGrid();
        }

        public void NSmyGrid_edit(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
        {

            NSmyGrid.EditItemIndex = (int)e.Item.ItemIndex;

            BindGrid();



        }

    }
}
