﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Configuration;

namespace NScontract.User
{
    /// <summary>
    /// UserBook 的摘要说明。
    /// </summary>
    public partial class UserBook : System.Web.UI.Page
    {
        SqlConnection NSconn;
        private string NSmysql;

        protected void Page_Load(object sender, System.EventArgs e)
        {
            if (Session["NSNickName"] != null)
            {
                //获得数据库连接字符串
                string NSconnection = ConfigurationSettings.AppSettings["strconnection"];
                //创建数据库连接
                NSconn = new SqlConnection(NSconnection);
                if (!IsPostBack)
                {
                    //自定义NS_DgBind()方法，加载自己连锁店产品的信息
                    BindGrid();
                    NSconn.Open();
                    string NSNickName = Session["NSNickName"].ToString();
                    NSmysql = "select NSBookDe.ID,NSBookDe.NSBookID,NSBookDe.NSBookName,NSBookDe.NSBookPrice,NSBookDe.NSBookDate,NSBookDe.NSBookSH,NSBookDe.NSBookInfo from NSBookDe,NSUser where NSBookDe.NSDepID = NSUser.NSDepID and NSUser.NSNickName = '" + NSNickName + "'";
                    //创建数据库SqlCommand对象
                    SqlCommand NScmd = new SqlCommand(NSmysql, NSconn);
                    SqlDataReader NSsdr = NScmd.ExecuteReader();
                    if (NSsdr.Read())
                    {
                        //将获取的ID保存到会话中
                        Session["ID"] = NSsdr["ID"];
                    }
                    NSconn.Close();
                }
            }
            else
            {
                Response.Redirect("../Index.aspx");
            }


        }



        public void BindGrid()
        {
            string NSNickName = Session["NSNickName"].ToString();
            //创建查询指定连锁店产品信息的sql语句
            NSmysql = "select NSBookDe.ID,NSBookDe.NSBookID,NSBookDe.NSBookName,NSBookDe.NSBookPrice,NSBookDe.NSBookDate,NSBookDe.NSBookSH,NSBookDe.NSBookInfo from NSBookDe,NSUser where NSBookDe.NSDepID = NSUser.NSDepID and NSUser.NSNickName = '" + NSNickName + "'";
            //创建SqlDataAdapter的实例
            SqlDataAdapter NSsda = new SqlDataAdapter(NSmysql, NSconn);
            //创建DataSet的实例
            DataSet NSds = new DataSet();
            //将信息填充到DataSet
            NSsda.Fill(NSds);
            //将信息绑定到DataGrid
            NSmyGrid.DataSource = NSds;
            NSmyGrid.DataBind();


        }

        //处理分页
        public void NSmyGrid_Page(object sender, DataGridPageChangedEventArgs e)
        {
            //获取DataGrid的当前显示页的索引
            NSmyGrid.CurrentPageIndex = e.NewPageIndex;
            BindGrid();
        }
        #region Web 窗体设计器生成的代码
        override protected void OnInit(EventArgs e)
        {
            //
            // CODEGEN: 该调用是 ASP.NET Web 窗体设计器所必需的。
            //
            InitializeComponent();
            base.OnInit(e);
        }

        /// <summary>
        /// 设计器支持所需的方法 - 不要使用代码编辑器修改
        /// 此方法的内容。
        /// </summary>
        private void InitializeComponent()
        {

        }
        #endregion


        public void dgItem(object source, DataGridCommandEventArgs e)
        {
            //获取要编辑的ID号
            int ID = int.Parse(e.Item.Cells[0].Text);
            //点击编辑按钮所触发的事件
            if (e.CommandName == "edit")
            {
                //弹出用于编辑的窗口
                Response.Write("<script language='javascript' defer>ret = window.showModalDialog('NSAddBook.aspx?Action=edit&id=" + ID + "',window,'dialogHeight:250px;dialogWidth:600px;center:Yes;Help:No;Resizable:No;Scroll:auto;Status:no;');</script>");
            }
            //点击删除所触发的事件
            if (e.CommandName == "delete")
            {
                //自定义delete()，删除指定ID的信息
                delete();
            }
            BindGrid();
        }

        private void NSmyGrid_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
        {

        }

        //加载delete()
        public void delete()
        {
            //获取需要删除的信息的id号
            string ID = Session["ID"].ToString();
            //创建删除指定id的产品信息的sql语句
            string NSstrsql = "delete from NSBooke  where ID = @ID";
            SqlCommand NScmd = new SqlCommand(NSstrsql, NSconn);
            NScmd.Parameters.Add(new SqlParameter("@ID", SqlDbType.Int, 4));
            NScmd.Parameters["@ID"].Value = ID;
            NScmd.Connection.Open();
            try
            {
                NScmd.ExecuteNonQuery();
            }
            catch (SqlException)
            {

            }
            NSmysql = "select NSBooke.ID,NSBook.* from NSBooke,NSBook,NSDep where NSBooke.NSDepID = NSDep.NSDepID and NSBooke.NSBookID = NSBook.NSBookID";
            NScmd.Connection.Close();
            Response.Redirect("NSUserBook.aspx");
        }


    }
}
