﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Data;
using System.Text;
using WebMvc.ViewData;
namespace WebMvc.Controllers
{
    [HandleError]    
    public class HomeController : Controller
    {        

        /// <summary>
        /// 首页
        /// </summary>
        /// <returns></returns>
        public ActionResult Index()
        {         
            ViewData["Message"] = "欢迎您访问动软中国网站!";

            Maticsoft.BLL.Products.Product bllpro = new Maticsoft.BLL.Products.Product();
            List<Maticsoft.Model.Product> prolist = bllpro.GetModelListByCategoryID(5, "");

            Maticsoft.BLL.NewsManage.News bllnews = new Maticsoft.BLL.NewsManage.News();
            List<Maticsoft.Model.News> newslist = bllnews.GetTopScroll(5); ;
            
            ViewData["Newslist"] = newslist;
            ViewData["Productlist"] = prolist;

            return View("Index");
        }

        /// <summary>
        /// 产品列表展示页
        /// </summary>
        /// <returns></returns>
        public ActionResult Products()
        {
            Maticsoft.BLL.Products.Product bllpro = new Maticsoft.BLL.Products.Product();
            List<Maticsoft.Model.Product> prolist = bllpro.GetModelListByCategoryID(15, "");

            ViewData["Productlist"] = prolist;
            return View("Products");
        }

        /// <summary>
        /// 新闻列表
        /// </summary>
        /// <param name="page"></param>
        /// <returns></returns>
        public ActionResult News(int? page)
        {
            Maticsoft.BLL.NewsManage.News bll = new Maticsoft.BLL.NewsManage.News();
            var viewData = new ModelViewData();
            int currentPage = page ?? 1;
            viewData.CurrentPage = currentPage;
            viewData.PageSize = 3;

            //方式一 分页存储过程 
            //viewData.Products = bllpro.GetModelList(currentPage, viewData.PageSize);
            //viewData.RowCount = bll.GetCount("");

            //方式二
            IEnumerable<Maticsoft.Model.News> modellist = bll.GetQueryModelList();
            viewData.RowCount = modellist.Count();
            viewData.News = modellist.Skip<Maticsoft.Model.News>((currentPage - 1) * viewData.PageSize).Take<Maticsoft.Model.News>(viewData.PageSize);

            return View(viewData);            
        }
        
        public ActionResult About()
        {
            return View();
        }

        public string FormatString(string str)
        {
            if (str.Length > 16)
            {
                str = str.Substring(0, 15) + "...";
            }
            return str;
        }
    }
}
