using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Mvc.Ajax;
using LTP.Accounts.Bus;
using WebMvc.ViewData;
namespace WebMvc.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    public class NewsController : Controller
    {
        Maticsoft.BLL.NewsManage.News bll = new Maticsoft.BLL.NewsManage.News();

        //
        // GET: /News/
        public ActionResult Index()
        {
            return View();
        }
        /// <summary>
        ///  Ʒбչʾҳ
        /// </summary>
        /// <returns></returns>
        public ActionResult List(int? page)
        {            
            var viewData = new ModelViewData();
            int currentPage = page ?? 1;
            viewData.CurrentPage = currentPage;
            viewData.PageSize = 3;

            //ʽһ ҳ洢             
            //viewData.Products = bllpro.GetModelList(currentPage, viewData.PageSize);
            //viewData.RowCount = bll.GetCount("");

            //ʽ
            IEnumerable<Maticsoft.Model.News> modellist = bll.GetQueryModelList();
            viewData.News = modellist.Skip<Maticsoft.Model.News>((currentPage - 1) * viewData.PageSize).Take<Maticsoft.Model.News>(viewData.PageSize);
            viewData.RowCount = modellist.Count();

            return View(viewData);  
        }


        //
        // GET: /News/Details/5
        public ActionResult Details(int id)
        {
            var model = bll.GetModel(id);
            return View(model);
        }

        //
        // GET: /News/Create
        public ActionResult Create()
        {
            Maticsoft.Model.News model = new Maticsoft.Model.News();
            return View(model);
        } 

        //
        // POST: /News/Create

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Create(FormCollection collection)
        {
            try
            {
                Maticsoft.Model.News model = new Maticsoft.Model.News();
                UpdateModel(model);
                model.Dormancy = model.Dormancy == "true" ? "false" : "true";
                model.Frequency = 0;
                model.IssueDate = DateTime.Now;
                model.IsTop = 1;
                model.Priority = 0;
                User currentUser=(User)Session["UserInfo"];
                model.UserId = currentUser.UserID;
                bll.Add(model);
                return RedirectToAction("List");
            }
            catch
            {
                return View();
            }
        }

        //
        // GET: /News/Edit/5 
        public ActionResult Edit(int id)
        {
            Maticsoft.Model.News model = new Maticsoft.Model.News();
            model = bll.GetModel(id);
            return View(model);
        }

        //
        // POST: /News/Edit/5
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Edit(int id, FormCollection collection)
        {
            try
            {
                Maticsoft.Model.News model = new Maticsoft.Model.News();
                model = bll.GetModel(id);
                UpdateModel(model);               
                model.IssueDate = DateTime.Now;
                bll.Update(model);
                return RedirectToAction("List");
            }
            catch
            {
                return View();
            }
        }

        // POST: /Product/Delete/5
        public ActionResult Delete(int id)
        {           
            bll.Delete(id);
            return RedirectToAction("List");
        }
    }
}
