using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Mvc.Ajax;
using WebMvc.ViewData;
namespace WebMvc.Controllers
{
    /// <summary>
    /// ƷController
    /// </summary>
    public class ProductController : Controller
    {
        Maticsoft.BLL.Products.Product bll = new Maticsoft.BLL.Products.Product(); 

        /// <summary>
        /// Ʒչʾҳ
        /// </summary>
        /// <returns></returns>
        public ActionResult Index(int? page)
        {            
            var viewData = new ModelViewData();
            int currentPage = page ?? 1;
            viewData.CurrentPage = currentPage;
            viewData.PageSize = 3;
                        
            //ʽһ  ҳ洢          
            //viewData.Products = bllpro.GetModelList(currentPage, viewData.PageSize);
            //viewData.RowCount = bll.GetCount("");
            
            //ʽ   
            IEnumerable<Maticsoft.Model.Product> modellist = bll.GetQueryModelList();
            viewData.RowCount = modellist.Count();
            viewData.Products = modellist.Skip<Maticsoft.Model.Product>((currentPage - 1) * viewData.PageSize).Take<Maticsoft.Model.Product>(viewData.PageSize);
            
            return View(viewData);            
        }

        /// <summary>
        ///  Ʒбչʾҳ
        /// </summary>
        /// <returns></returns>
        public ActionResult List(int? page)
        {            
            var viewData = new ModelViewData();
            int currentPage = page ?? 1;
            viewData.CurrentPage = currentPage;
            viewData.PageSize = 3;


            //ʽһ ҳ洢             
            //viewData.Products = bllpro.GetModelList(currentPage, viewData.PageSize);
            //viewData.RowCount = bll.GetCount("");
            
            //ʽ
            IEnumerable<Maticsoft.Model.Product> modellist = bll.GetQueryModelList();
            viewData.RowCount = modellist.Count();
            viewData.Products = modellist.Skip<Maticsoft.Model.Product>((currentPage - 1) * viewData.PageSize).Take<Maticsoft.Model.Product>(viewData.PageSize);
                        
            return View(viewData);
        }


        //
        // GET: /Product/Create
        public ActionResult Create()
        {
            Maticsoft.Model.Product model = new Maticsoft.Model.Product();
            return View(model);
        }
        //
        // POST: /Product/Create
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Create(FormCollection collection)
        {
            try
            {
                Maticsoft.Model.Product model = new Maticsoft.Model.Product();
                UpdateModel(model);
                bll.Add(model);
                return RedirectToAction("List");
            }
            catch
            {
                return View();
            }
        }

        //
        // GET: /Product/Details/5
        public ActionResult Details(string id)
        {
            var model = bll.GetModel(id);
            return View(model);
        }
               

        //
        // GET: /Product/Edit/5 
        public ActionResult Edit(string id)
        {
            Maticsoft.Model.Product model = new Maticsoft.Model.Product();
            model = bll.GetModel(id);
            return View(model);
        }

        //
        // POST: /Product/Edit/5
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Edit(string id, FormCollection collection)
        {
            try
            {
                Maticsoft.Model.Product model = new Maticsoft.Model.Product();
                model = bll.GetModel(id);
                UpdateModel(model);
                bll.Update(model);
                return RedirectToAction("List");
            }
            catch
            {
                return View();
            }
        }

        // POST: /Product/Delete/5
        public ActionResult Delete(string id)
        {            
            bll.Delete(id);
            return RedirectToAction("List");
        }
    }
}
