using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;

namespace Bll
{
	public class ExpenseManage
	{
		private static readonly string sqlcmd = "select EXPENSES.id,EMPLOYEE.name,EXPENSES.expenses_price,EXPENSES.ues,EXPENSES.insert_date_time,EXPENSES.mome from dbo.EXPENSES inner join dbo.EMPLOYEE on EXPENSES.emp_id = EMPLOYEE.id order by insert_date_time";
		private static readonly string sqlcmd1 = "select sum(expenses_price) as ff from dbo.EXPENSES where insert_date_time between '" + DateTime.Now.ToShortDateString() + "' and dateadd(d,1,'" + DateTime.Now.ToShortDateString()+ "')";
		private static readonly string sqlcmd2 = "select * from EMPLOYEE";
		/// <summary>
		/// DataSet
		/// </summary>
		/// <returns></returns>
		public DataSet ReturnDataSet(string day,string month)
		{
			DataSet dss = new DataSet();
			DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
			//Ĭϲѯ
			if (day == "" && month== "")
			{
				using (SqlDataReader reader = sqlhelp.GetSqlDataReader(sqlcmd))
				{
					DataTable dt = new DataTable("Expense");
					dt.Columns.Add(new DataColumn("id", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("name", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("price", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("ues", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("insert_date_time", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("mome", Type.GetType("System.String")));

					while (reader.Read())
					{
						DataRow dr = dt.NewRow();
						dr["id"] = reader[0];
						dr["name"] = reader["name"];
						dr["price"] = reader["expenses_price"];
						dr["ues"] = reader["ues"];
						dr["insert_date_time"] = reader["insert_date_time"];
						dr["mome"] = reader["mome"];
						dt.Rows.Add(dr);
					}
					dss.Tables.Add(dt);
				}
			}

			//ѯ
			if (day != "" && month =="")
			{
				string dayQuery = "select EXPENSES.id,EMPLOYEE.name,EXPENSES.expenses_price,EXPENSES.ues,EXPENSES.insert_date_time,EXPENSES.mome from dbo.EXPENSES inner join dbo.EMPLOYEE on EXPENSES.emp_id = EMPLOYEE.id where insert_date_time between '" + Convert.ToDateTime(day) + "' and dateadd(d,1,'" + Convert.ToDateTime(day) + "') order by insert_date_time";
				using (SqlDataReader reader = sqlhelp.GetSqlDataReader(dayQuery))
				{
					DataTable dt = new DataTable("Expense");
					dt.Columns.Add(new DataColumn("id", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("name", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("price", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("ues", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("insert_date_time", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("mome", Type.GetType("System.String")));

					while (reader.Read())
					{
						DataRow dr = dt.NewRow();
						dr["id"] = reader[0];
						dr["name"] = reader["name"];
						dr["price"] = reader["expenses_price"];
						dr["ues"] = reader["ues"];
						dr["insert_date_time"] = reader["insert_date_time"];
						dr["mome"] = reader["mome"];
						dt.Rows.Add(dr);
					}
					dss.Tables.Add(dt);
				}
			}

			//²ѯ
			if (day == "" && month != "")
			{
				string monthQuery = "select EXPENSES.id,EMPLOYEE.name,EXPENSES.expenses_price,EXPENSES.ues,EXPENSES.insert_date_time,EXPENSES.mome from dbo.EXPENSES inner join dbo.EMPLOYEE on EXPENSES.emp_id = EMPLOYEE.id where insert_date_time between '" + Convert.ToDateTime(month) + "' and dateadd(m,1,'" + Convert.ToDateTime(month) + "') order by insert_date_time";
				using (SqlDataReader reader = sqlhelp.GetSqlDataReader(monthQuery))
				{
					DataTable dt = new DataTable("Expense");
					dt.Columns.Add(new DataColumn("id", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("name", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("price", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("ues", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("insert_date_time", Type.GetType("System.String")));
					dt.Columns.Add(new DataColumn("mome", Type.GetType("System.String")));

					while (reader.Read())
					{
						DataRow dr = dt.NewRow();
						dr["id"] = reader[0];
						dr["name"] = reader["name"];
						dr["price"] = reader["expenses_price"];
						dr["ues"] = reader["ues"];
						dr["insert_date_time"] = reader["insert_date_time"];
						dr["mome"] = reader["mome"];
						dt.Rows.Add(dr);
					}
					dss.Tables.Add(dt);
				}
			}

			return dss;
		}

		/// <summary>
		/// ɾһ¼
		/// </summary>
		/// <param name="id"></param>
		public void Delete(string id)
		{
			DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
			sqlhelp.RunSql("delete EXPENSES where id ='"+id+"'");
		}

		/// <summary>
		/// ͳ֧
		/// </summary>
		/// <returns></returns>
		public int GetAllExpenses(DateTime day, DateTime month)
		{
			string sqlday = "select sum(expenses_price) as ff from dbo.EXPENSES where insert_date_time between '" + Convert.ToDateTime(day) + "' and dateadd(d,1,'" + Convert.ToDateTime(day) + "')";
			string sqlmonth = "select sum(expenses_price) as ff from dbo.EXPENSES where insert_date_time between '" + Convert.ToDateTime(month) + "' and dateadd(m,1,'" + Convert.ToDateTime(month) + "') ";
			int number = 0;
			if (day.ToShortDateString() != "1900-1-1" & month.ToShortDateString() == "1900-1-1")
			{
				DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
				number =  sqlhelp.RunSqlReturn(sqlday);
			}
			if (day.ToShortDateString() == "1900-1-1" && month.ToShortDateString() != "1900-1-1")
			{
				DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
				number = sqlhelp.RunSqlReturn(sqlmonth);
			}
			if (day.ToShortDateString() == "1900-1-1" && month.ToShortDateString() == "1900-1-1")
			{
				DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
				number = sqlhelp.RunSqlReturn(sqlcmd1);
			}
			return number;
		}

		/// <summary>
		/// õеԱϢ
		/// </summary>
		/// <returns></returns>
		public DataSet GetAllEmplyee()
		{
			DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
			return sqlhelp.GetDs(sqlcmd2);
		}

		/// <summary>
		/// ȡƿ
		/// </summary>
		/// <param name="name"></param>
		/// <param name="id"></param>
		public void Tack_bottle(string name,string id)
		{
			string sqlstr = "update orders set TACK_BOTTLEER = '"+name+"' where id = '"+id+"'";
			DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
			sqlhelp.RunSql(sqlstr);
		}

		/// <summary>
		/// ƿ
		/// </summary>
		/// <param name="name"></param>
		/// <param name="id"></param>
		public void Delivery_bottle(string name, string id)
		{
			string sqlstr = "update orders set DELI_BOTTLEER = '" + name + "' where id = '" + id + "'";
			DataBaseDrHelp sqlhelp = new DataBaseDrHelp();
			sqlhelp.RunSql(sqlstr);
		}
	}
}
