﻿using System.Configuration;
using System.Data;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Xml;

namespace ToolServer {
    public class RssServer : IHttpHandler {
        public bool IsReusable {
            get { return false; }
        }

        public void ProcessRequest(HttpContext context) {
            if (context.Request.QueryString["url"] != null) {

                string url = context.Request.QueryString["url"];
                XmlDocument rss = new XmlDocument();
                rss.Load(url);
                XmlNamespaceManager namespacemanager = new XmlNamespaceManager(rss.NameTable);
                namespacemanager.AddNamespace("myrss", url);
                XmlNodeList list = rss.SelectNodes("/rss/channel/item", namespacemanager);
                DataTable dt = new DataTable("rss");
                DataColumn DcTitile = new DataColumn("title");
                dt.Columns.Add(DcTitile);
                DataColumn DcUrl = new DataColumn("url");
                dt.Columns.Add(DcUrl);
                DataColumn DcDescription = new DataColumn("Description");
                dt.Columns.Add(DcDescription);
                int rssCount = int.Parse(ConfigurationManager.AppSettings["RssCount"].ToString());
                if (list == null) return;
                if (list.Count > rssCount) {
                    int i = 0;
                    foreach (XmlNode node in list) {
                        if (i < rssCount) {
                            DataRow dr = dt.NewRow();
                            XmlNode Title = node.SelectSingleNode("title");
                            if (Title != null)
                                dr[0] = NoSpecialChar(NoHTML(Title.InnerText));
                            XmlNode Link = node.SelectSingleNode("link");
                            if (Link != null)
                                dr[1] = NoSpecialChar(NoHTML(Link.InnerText));
                            XmlNode Des = node.SelectSingleNode("description");
                            if (Des != null)
                                dr[2] = NoSpecialChar(NoHTML(Des.InnerText));
                            dt.Rows.Add(dr);
                            i++;
                        }
                    }
                }
                else {
                    foreach (XmlNode node in list) {
                        DataRow dr = dt.NewRow();
                        XmlNode Title = node.SelectSingleNode("title");
                        if (Title != null)
                            dr[0] = NoSpecialChar(NoHTML(Title.InnerText));
                        XmlNode Link = node.SelectSingleNode("link");
                        if (Link != null)
                            dr[1] = NoSpecialChar(NoHTML(Link.InnerText));
                        XmlNode Des = node.SelectSingleNode("description");
                        if (Des != null)
                            dr[2] = NoSpecialChar(NoHTML(Des.InnerText));
                        dt.Rows.Add(dr);
                    }
                }
                context.Response.Write(CreateJsonParameters(dt));
                context.Response.End();

            }
        }

        public static string NoSpecialChar(string strinput) {
            string result = "";
            result = strinput.Replace("\"", "\\\"");
            result = result.Replace("\\", "\\\\");
            result = result.Replace("/", "\\/");
            result = result.Replace("\b", "\\b");
            result = result.Replace("\f", "\\f");
            result = result.Replace("\n", "\\n");
            result = result.Replace("\r", "\\r");
            result = result.Replace("\t", "\\t");
            return result;
        }

        public static string CreateJsonParameters(DataTable dt) {
            StringBuilder JsonString = new StringBuilder();
            //Exception Handling        
            if (dt != null && dt.Rows.Count > 0) {
                JsonString.Append("[ ");
                for (int i = 0; i < dt.Rows.Count; i++) {
                    JsonString.Append("{ ");
                    for (int j = 0; j < dt.Columns.Count; j++) {
                        if (j < dt.Columns.Count - 1) {
                            JsonString.Append("\"" + dt.Columns[j].ColumnName.ToString() + "\":" + "\"" + dt.Rows[i][j].ToString() + "\",");
                        }
                        else if (j == dt.Columns.Count - 1) {
                            JsonString.Append("\"" + dt.Columns[j].ColumnName.ToString() + "\":" + "\"" + dt.Rows[i][j].ToString() + "\"");
                        }
                    }
                    /**/
                    /*end Of String*/
                    if (i == dt.Rows.Count - 1) {
                        JsonString.Append("} ");
                    }
                    else {
                        JsonString.Append("}, ");
                    }
                }
                JsonString.Append("]");
                return JsonString.ToString();
            }
            else {
                return null;
            }
        }

        public static string NoHTML(string Htmlstring) {
            //删除脚本
            Htmlstring = Regex.Replace(Htmlstring, @"<script[^>]*?>.*?</script>", "",
              RegexOptions.IgnoreCase);
            //删除HTML
            Htmlstring = Regex.Replace(Htmlstring, @"<(.[^>]*)>", "",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"([\r\n])[\s]+", "",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"-->", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"<!--.*", "", RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(quot|#34);", "\"",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(amp|#38);", "&",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(lt|#60);", "<",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(gt|#62);", ">",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(nbsp|#160);", "   ",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(iexcl|#161);", "\xa1",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(cent|#162);", "\xa2",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(pound|#163);", "\xa3",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&(copy|#169);", "\xa9",
              RegexOptions.IgnoreCase);
            Htmlstring = Regex.Replace(Htmlstring, @"&#(\d+);", "",
              RegexOptions.IgnoreCase);
            Htmlstring.Replace("<", "");
            Htmlstring.Replace(">", "");
            Htmlstring.Replace("\r\n", "");
            Htmlstring = HttpContext.Current.Server.HtmlEncode(Htmlstring).Trim();

            return Htmlstring;
        }
    }
}
