using System;
using System.Data ;
using System.Data.OleDb ;

namespace PMS.Common
{
	public class DataAccess
	{
		private OleDbConnection OleConnString ;
		private OleDbTransaction trans ;
		/******************************************************************************
		 * FunName	:	ExecSqlInTrans
		 * Input	:	strSqls
		 * Return	:	bool
		 * Describe	:	
		 *		This function is to execute a set of sql strings splitted by ";", such as 
		 * "insert into acl values('admin','UserMng');insert into acl values('Jason','LogMng')" ;
		 * 
		 * In the example as up, the function can execute two sql strings in one transaction. when 
		 * one sql string executing is failure, the two executing will both rollback to the old 
		 * state.
		 * 
		 * ****************************************************************************/
		public bool ExecSqlInTrans(string strSqls) 
		{
			OleConnString = GetConnect() ;
			OleDbCommand OleCmd = new OleDbCommand("",OleConnString) ;
			OleConnString.Open() ;
			trans = OleConnString.BeginTransaction() ;
			OleCmd.Transaction = trans ;
			try
			{
				int i = 0 ; 
				string[] strSql = strSqls.Split(';') ;
				for(i=0;i<strSql.Length;i++)
				{
					OleCmd.CommandText = strSql[i] ;
					if(OleCmd.ExecuteNonQuery() < 0)
					{
						OleCmd.Transaction.Rollback() ;
						return false ;
					}
				}
				OleCmd.Transaction.Commit() ;
				return true ;
			}
			catch
			{
				OleCmd.Transaction.Rollback() ;
				return false ;
			}
			finally
			{
				OleConnString.Close() ;
			}
		}
	
		/// <summary>
		/// ݿ
		/// </summary>
		/// <returns>OleDbConnection</returns>
		public OleDbConnection GetConnect()
		{
			string strOleSqlConn = System.Configuration.ConfigurationSettings.AppSettings["Connection"] ;
			OleConnString = new OleDbConnection(strOleSqlConn) ;
			return OleConnString ;
		}
		
		/// <summary>
		/// ִвѯ
		/// </summary>
		/// <param name="strSql"></param>
		/// <returns>OleDbDataReader</returns>
		public OleDbDataReader GetDataReader(string strSql) 
		{
			OleConnString = GetConnect() ;
			OleConnString.Open() ;
			try
			{
				OleDbCommand OleCmd = new OleDbCommand(strSql,OleConnString) ;
				OleDbDataReader OleDr = OleCmd.ExecuteReader() ;
				return OleDr ;
			}
			finally
			{
				OleConnString.Close() ;
			}
		}
		
		/// <summary>
		/// ִвѯ
		/// </summary>
		/// <param name="strSql"></param>
		/// <returns>DataSet</returns>
		public DataSet GetDataSet(string strSql) 
		{
			OleConnString = GetConnect() ;
			OleConnString.Open() ;
			try
			{
				DataSet OleDs = new DataSet() ;
				OleDbDataAdapter OleDa = new OleDbDataAdapter(strSql,OleConnString) ;
				OleDa.Fill(OleDs) ;
				return OleDs ;
			}
			finally
			{
				OleConnString.Close() ;
			}
		}
		
		/// <summary>
		/// ִвѯ
		/// </summary>
		/// <param name="strSql"></param>
		/// <returns>DataView</returns>
		public DataView CreateDataView(string strSql) 
		{
			OleConnString = GetConnect() ;
			OleConnString.Open() ;
			try
			{
				DataSet DS = new DataSet() ;
				OleDbDataAdapter OleDa = new OleDbDataAdapter(strSql,OleConnString) ;
				OleDa.Fill(DS) ;
				DataView DV = new DataView() ;
				DV.Table = DS.Tables[0] ;
				return DV ;
			}
			finally
			{
				OleConnString.Close() ;
			}
		}
		
		/// <summary>
		/// ִвѯ
		/// </summary>
		/// <param name="strSql"></param>
		/// <returns>CreateDataTable</returns>
		public DataTable CreateDataTable(string strSql) 
		{
			OleConnString = GetConnect() ;
			OleConnString.Open() ;
			try
			{
				DataSet DS = new DataSet() ;
				OleDbDataAdapter OleDa = new OleDbDataAdapter(strSql,OleConnString) ;
				OleDa.Fill(DS) ;
				DataTable DT = new DataTable() ;
				DT = DS.Tables[0] ;
				return DT ;
			}
			finally
			{
				OleConnString.Close() ;
			}
		}
		/// <summary>
		/// Sql䣬ʵɾĲ
		/// </summary>
		/// <param name="strSql"></param>
		/// <returns>bool</returns>
		public bool ExecSql(string strSql) 
		{
			OleConnString = GetConnect() ;
			OleDbCommand OleCmd = new OleDbCommand(strSql,OleConnString) ;
			OleConnString.Open() ;
			try
			{
				if(OleCmd.ExecuteNonQuery() > 0)
				{
					return true ;
				}
				else
				{
					return false ;
				}
			}
			catch(Exception ex)
			{
				return false ;
			}
			finally
			{
				OleConnString.Close() ;
			}
		}

	}
}
