﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class EnrolIn : System.Web.UI.Page
{
    public static int flag;//是否单击了物资编号，单击为１，没单击为０
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["flag"] == null)//是否正确登录
        {
            Response.Redirect("../../Login.aspx");
        }
        if (!IsPostBack)
         {
            this.txtAmount.Attributes["onkeyup"] = "value=value.replace(/[^\\d]/g,'')";//设置txtAmount的输入文本只能为数字
            this.txtUnitPrise.Attributes["onkeyup"] = "value=value.replace(/[^\\d]/g,'')";//设置txtUnitPrise的输入文本只能为数字
            SqlConnection conn = DB.GetCon();
            conn.Open();
            AutoID(conn);//根据数据库中的记录数自动产生一个数作为入库单ID
            this.Panel1.Visible = false;//初始化页面时，把Panel1设置为不可见，隐藏了物资选择模块
            this.bind();//绑定数据使DropDownList控件根据数据库数据动态添加子项
            DataSet ds = DB.reDs("SELECT  Title FROM tb_BigType where Type='物资大类'");//下面的方法动态添加了TreeView的根节点和子节点
            for (int i = 0; i < ds.Tables[0].Rows.Count; i++)
            {
                //显示数据库中的类别并给TreeView根节点
                TreeNode tree1 = new TreeNode(ds.Tables[0].Rows[i][0].ToString());
                this.TreeView1.Nodes.Add(tree1);
                DataSet ds1 = DB.reDs("select title from tb_Type Where type='" + ds.Tables[0].Rows[i][0].ToString() + "'");
                //显示TreeView根节点下的子节点
                for (int j = 0; j < ds1.Tables[0].Rows.Count; j++)
                {
                    TreeNode tree2 = new TreeNode(ds1.Tables[0].Rows[j][0].ToString(), ds1.Tables[0].Rows[j][0].ToString());
                    tree1.ChildNodes.Add(tree2);
                }
            }
        }
    }
    //根据数据库中的记录数自动产生一个数作为入库单ID
    public void AutoID(SqlConnection conn)
    {
        SqlCommand com = new SqlCommand("select count(*) from tb_Store", conn);//conn为传入的连接对象
        int Count = Convert.ToInt32(com.ExecuteScalar());
        this.txtStoreID.Text = Convert.ToString(Count + 1);//根据数据库中的记录数自动产生一个数作为入库单ID
        if (conn.State == ConnectionState.Open)
        {
            com.Dispose();
            conn.Close();
        }
            
    }
    public void bind()
    {
        DataSet ds1 = DB.reDs("select Title from tb_BigType where Type='仓库'");
        this.ddlStorePlace.DataSource = ds1;
        ddlStorePlace.DataTextField = "Title";
        ddlStorePlace.DataBind();
        DataSet ds2 = DB.reDs("select Title from tb_BigType where Type='部门'");
        this.ddlDepartment.DataSource = ds2;
        ddlDepartment.DataTextField = "Title";
        ddlDepartment.DataBind();
        DataSet ds3 = DB.reDs("select * from tb_Enterprise  where Type1='是'");
        this.ddlCustomer.DataSource = ds3;
        ddlCustomer.DataTextField = "Name";
        ddlCustomer.DataValueField = "CustomerID";
        ddlCustomer.DataBind();
        DataSet ds4 = DB.reDs("select * from tb_BigType where Type='入库类型'");
        ddlStoreType.DataSource = ds4;
        ddlStoreType.DataTextField = "Title";
        this.ddlStoreType.DataBind();
        DataSet ds5 = DB.reDs("select * from tb_BigType where Type='计量单位'");
        ddlUnit.DataSource = ds5;
        ddlUnit.DataTextField = "Title";
        this.ddlUnit.DataBind();
    }
    //使页面恢复初始状态
    public void clear()
    {
        //遍历控件查找文本框控件，并清空
        foreach (Control c in this.form1 .Controls)
        {
            if (c.GetType().ToString() == "System.Web.UI.WebControls.TextBox")
            {
                TextBox t = (TextBox)c;
                t.Text = "";
            }
        }
        //遍历控件查找DropDownList控件，并恢复默认选项
        
        foreach (Control c in this.form1.Controls)
        {
            if (c.GetType().ToString() == "System.Web.UI.WebControls.DropDownList")
            {
                DropDownList d = (DropDownList )c;
                d.SelectedIndex =-1;
            }
        }
    }

    protected void lnkButtonWzID_Click(object sender, EventArgs e)
    {
        this.Panel1.Visible = true;
    }
    protected void gvStatistic_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {
        this.Panel1.Visible = false;
        string id = this.gvStatistic.DataKeys[e.NewSelectedIndex].Value.ToString();//取得主键值
        DataSet ds = DB.reDs("select * from tb_Material where WzID='" + id + "'");//返回根据主键值从数据库中筛选到记录
        this.lnkWzID.Text = ds.Tables[0].Rows[0][0].ToString();//绑定到控件上显示出来
        this.txtName.Text = ds.Tables[0].Rows[0][2].ToString();
        this.txtModel.Text = ds.Tables[0].Rows[0][3].ToString();
        this.txtSpec.Text = ds.Tables[0].Rows[0][4].ToString();
        this.txtCard.Text = ds.Tables[0].Rows[0][5].ToString();
        this.txtUnitPrise.Text = ds.Tables[0].Rows[0][6].ToString();
    }
    protected void ddlCustomer_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (this.ddlCustomer.SelectedItem.ToString() != "选择供应商")
        {
            string CustomerID = this.ddlCustomer.SelectedValue.ToString();//取得主键值
            DataSet ds = DB.reDs("select * from tb_Enterprise  where CustomerID='" + CustomerID + "'");//返回根据主键值从数据库中筛选到的记录
            this.txtAddress.Text = ds.Tables[0].Rows[0][2].ToString();//绑定到控件上显示出来
            this.txtPhone.Text = ds.Tables[0].Rows[0][3].ToString();
            this.txtLinkMan.Text = ds.Tables[0].Rows[0][4].ToString();
        }
        else
        {
            this.txtAddress.Text = "";
            this.txtPhone.Text ="";
            this.txtLinkMan.Text = "";
        }  
    }
    protected void btnClickOK_Click(object sender, EventArgs e)
    {
        string StoreID = this.txtStoreID.Text.Trim();
        string StoreDate = this.txtStoreDate.Text;
        string StoreType = this.ddlStoreType.Text.Trim();
        string StorePlace = this.ddlStorePlace.SelectedValue.ToString();
        string Sign = this.txtSign.Text.Trim();
        string BuyDate = this.txtBuyDate.Text.Trim();
        string BuyDepartment = this.ddlDepartment.SelectedValue.ToString();
        string BuyMan = this.txtBuyMan.Text.Trim();
        string Ratify = this.txtRatify.Text.Trim();
        string Remark = this.txtRemark.Text.Trim();
        string WzID = this.lnkWzID.Text.ToString();
        string Name = this.txtName.Text.Trim();
        string Model = this.txtModel.Text.Trim();
        string Spec = this.txtSpec.Text.Trim();
        string Card = this.txtCard.Text.Trim();
        string UnitPrise = this.txtUnitPrise.Text.Trim();
        string Unit = this.ddlUnit.SelectedValue.ToString();
        string Amount = this.txtAmount.Text.Trim();
        string Pay = this.txtPay.Text.Trim();
        string CustomerID = this.ddlCustomer.SelectedValue.ToString();
        string Customer = this.ddlCustomer.SelectedItem.Text;
        string Address = this.txtAddress.Text.Trim();
        string Phone = this.txtPhone.Text.Trim();
        string LinkMan = this.txtLinkMan.Text.Trim();
        try
        {
            bool b=DB.ExSql("insert into tb_Store values('" + StoreID + "','" + StoreDate + "', '" + StoreType + "', '" + StorePlace + "', '" + Sign + "', '" + BuyDate + "', '" + BuyDepartment + "','" + BuyMan + "','" + Ratify + "','" + Remark + "')");
            if(b)
                DB.ExSql("insert into tb_StoreDetails values('" + StoreID + "','" + WzID + "','" + Name + "','" + Model + "','" + Spec + "','" + Card + "'," + UnitPrise + ",'" + Unit + "','" + Amount + "'," + Pay + ",'" + CustomerID + "','" + Customer + "','" + Address + "','" + Phone + "','" + LinkMan + "') ");
            //使页面恢复初始状态
            this.clear();       
            SqlConnection conn = DB.GetCon();
            conn.Open();
            AutoID(conn);//根据数据库中的记录数自动产生一个数作为入库单ID
            this.lnkWzID.Text = "物资编号";
        }
        catch (SqlException oe)
        {
            Response.Write( "<script language='javascript'>alert('"+oe.Message+"')</script>");
        }
    }
    protected void TxtAmount_TextChanged(object sender, EventArgs e)
    {
        float UnitPrise = float.Parse(this.txtUnitPrise.Text.ToString());
        if (txtUnitPrise.Text == "")
        {
            UnitPrise = 1;
        }
        int Amount = int.Parse(this.txtAmount.Text.ToString());
        this.txtPay.Text = Convert.ToString(UnitPrise * Amount);
    }
    protected void TreeView1_SelectedNodeChanged(object sender, EventArgs e)
    {
        DataSet ds = DB.reDs("select * from tb_Material where WzType='" + this.TreeView1.SelectedNode.Value.ToString() + "'");
        if (ds.Tables[0].Rows.Count != 0)
        {
            this.gvStatistic.DataSource = ds;
            this.gvStatistic.DataKeyNames = new string[] { "WzID" };
            this.gvStatistic.DataBind();
        }
    }
    protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
    {
        string time = args.Value;
        try
        {
            DateTime datetime = Convert.ToDateTime(time);
        }
        catch
        {
            CustomValidator1.Text = "您输入的时间格式有误";
            args.IsValid = false;
        }
    }
    protected void CustomValidator2_ServerValidate(object source, ServerValidateEventArgs args)
    {
        string time = args.Value;
        try
        {
            DateTime datetime = Convert.ToDateTime(time);
        }
        catch
        {
            CustomValidator2.Text = "您输入的时间格式有误";
            args.IsValid = false;
        }
    }

    protected void gvStatistic_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        this.gvStatistic.PageIndex = e.NewPageIndex;
        DataSet ds = DB.reDs("select * from tb_Material where WzType='" + this.TreeView1.SelectedNode.Value.ToString() + "'");
        if (ds.Tables[0].Rows.Count != 0)
        {
            this.gvStatistic.DataSource = ds;
            this.gvStatistic.DataKeyNames = new string[] { "WzID" };
            this.gvStatistic.DataBind();
        }
    }
}
