﻿using System.Data;
using System.Web.UI.WebControls;

namespace Jinlong.Bind
{

    public static   class JCheckBoxList
    {

        /// <summary>
        /// 绑顶数据源到指定的CheckBoxList
        /// </summary>
        /// <param name="chklst">CheckBoxList控件</param>
        /// <param name="dataSource">数据源</param>
        /// <param name="textField">文本字段</param>
        /// <param name="valueField">值字段</param>
        public static void BindList(System.Web.UI.WebControls.CheckBoxList chklst, DataTable dataSource, string textField, string valueField)
        {
            chklst.DataSource = dataSource;
            chklst.DataTextField = textField;
            chklst.DataValueField = valueField;
            chklst.DataBind();
        }


        /// <summary>
        /// 使CheckBoxList中指定集合的项选中
        /// </summary>
        /// <param name="chklst">CheckBoxList控件</param>
        /// <param name="itemValues">要匹配的值的集合</param>
        public static void SetSelectedList(System.Web.UI.WebControls.CheckBoxList chklst, string[] itemValues)
        {
            chklst.SelectedIndex = -1;
            foreach (string item in itemValues)
            {
                if (item != null)
                {
                    foreach (ListItem it in chklst.Items)
                    {
                        if (it.Value == item)
                        {
                            it.Selected = true;
                        }
                    }
                }
            }
        }


        /// <summary>
        /// 返回选中CheckBoxList的string[]数组
        /// </summary>
        /// <param name="chklst">CheckBoxList控件</param>
        /// <param name="textValue">返回Value</param>
        public static string GetSelectedList(System.Web.UI.WebControls.CheckBoxList chklst)
        {
            if (chklst.Items.Count == 0)
                return null;
            string items = "";
            foreach (ListItem item in chklst.Items)
            {
                if (item.Selected)
                {
                    items += "," + item.Value;
                }
            }
            if (items == string.Empty)
                return null;
            items = items.Substring(1);
            return items;
        }


    }
}
