﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Web.UI.WebControls;

namespace Jinlong.Bind
{
    public static class JDropDownList
    {


        /// <summary>
        /// 绑顶数据源到指定的DropDownList
        /// </summary>
        /// <param name="drp">DropDownList控件</param>
        /// <param name="dataSource">数据源</param>
        /// <param name="textField">文本字段</param>
        /// <param name="valueField">值字段</param>
        public static void BindList(System.Web.UI.WebControls.DropDownList drp, DataTable dataSource, string textField, string valueField)
        {
            drp.Items.Clear();
            foreach (DataRow dr in dataSource.Rows)
            {
                drp.Items.Add(new ListItem(dr[textField].ToString(), dr[valueField].ToString()));
            }
        }


        /// <summary>
        /// 使DropDownList中指定值的项选中
        /// </summary>
        /// <param name="drp">DropDownList控件</param>
        /// <param name="itemValue">要匹配的值</param>
        /// <param name="textValue">匹配项的Text还是Value</param>
        public static void SetSelectedList(System.Web.UI.WebControls.DropDownList drp, string itemValue)
        {
            drp.SelectedIndex = -1;
            foreach (ListItem item in drp.Items)
            {
                if (item.Value == itemValue)
                {
                    item.Selected = true;
                    return;
                }
            }
        }


        /// <summary>
        /// 返回选中DropDownList的string
        /// </summary>
        /// <param name="drp">DropDownList控件</param>
        /// <param name="textValue">返回Value</param>
        public static string GetSelectedList(System.Web.UI.WebControls.DropDownList drp)
        {
            if (drp.Items.Count == 0)
                return "";
            foreach (ListItem item in drp.Items)
            {
                if (item.Selected)
                {
                    return item.Value;
                }
            }
            return "";
        }


 
    }
}
