﻿using System.Data;
using System.Web.UI.WebControls;

namespace Jinlong.Bind
{

    public static  class JListBox
    {

        /// <summary>
        /// 绑顶数据源到指定的ListBox
        /// </summary>
        /// <param name="lstbox">ListBox控件</param>
        /// <param name="dataSource">数据源</param>
        /// <param name="textField">文本字段</param>
        /// <param name="valueField">值字段</param>
        public static void BindList(System.Web.UI.WebControls.ListBox lstbox, DataTable dataSource, string textField, string valueField)
        {
            lstbox.DataSource = dataSource;
            lstbox.DataTextField = textField;
            lstbox.DataValueField = valueField;
            lstbox.DataBind();
        }


        /// <summary>
        /// 使ListBox中指定集合的项选中
        /// </summary>
        /// <param name="lstbox">ListBox控件</param>
        /// <param name="itemValues">要匹配的值的集合</param>
        /// <param name="textValue">匹配项的Value</param>
        public static void SetSelectedList(System.Web.UI.WebControls.ListBox lstbox, string[] itemValues)
        {
            lstbox.SelectedIndex = -1;
            foreach (string item in itemValues)
            {
                if (item != null)
                {
                    foreach (ListItem it in lstbox.Items)
                    {
                        if (it.Value == item)
                        {
                            it.Selected = true;
                        }
                    }
                }
            }
        }



        /// <summary>
        /// 返回选中ListBox的string[]数组
        /// </summary>
        /// <param name="lstbox">ListBox控件</param>
        /// <param name="textValue">返回Value</param>
        public static string GetSelectedList(System.Web.UI.WebControls.ListBox lstbox)
        {
            if (lstbox.Items.Count == 0)
                return null;
            string items = "";
            foreach (ListItem item in lstbox.Items)
            {
                if (item.Selected)
                {
                    items += "," + item.Value;
                }
            }
            if (items == string.Empty)
                return null;
            items = items.Substring(1);
            return items;
        }


    }
}
