﻿using System.Data;
using System.Web.UI.WebControls;

namespace Jinlong.Bind
{
    public static  class JRadioButtonList
    {

        /// <summary>
        /// 绑顶数据源到指定的RadioButtonList
        /// </summary>
        /// <param name="radlst">CheckBoxList控件</param>
        /// <param name="dataSource">数据源</param>
        /// <param name="textField">文本字段</param>
        /// <param name="valueField">值字段</param>
        public static void BindList(System.Web.UI.WebControls.RadioButtonList radlst, DataTable dataSource, string textField, string valueField)
        {
            radlst.DataSource = dataSource;
            radlst.DataTextField = textField;
            radlst.DataValueField = valueField;
            radlst.DataBind();
        }

        /// <summary>
        /// 使RadioButtonList中指定值的项选中
        /// </summary>
        /// <param name="radlst">RadioButtonList控件</param>
        /// <param name="itemValue">要匹配的值的集合</param>
        /// <param name="textValue">匹配项的Value</param>
        public static void SetSelectedList(System.Web.UI.WebControls.RadioButtonList radlst, string itemValue)
        {
            radlst.SelectedIndex = -1;
            foreach (ListItem it in radlst.Items)
            {
                if (it.Value == itemValue)
                {
                    it.Selected = true;
                    return;
                }
            }
        }


        /// <summary>
        /// 返回选中RadioButtonList的string
        /// </summary>
        /// <param name="radlst">RadioButtonList控件</param>
        /// <param name="textValue">返回Value</param>
        public static string GetSelectedList(System.Web.UI.WebControls.RadioButtonList radlst)
        {
            if (radlst.Items.Count == 0)
                return "";
            foreach (ListItem item in radlst.Items)
            {
                if (item.Selected)
                {
                    return item.Value;
                }
            }
            return "";
        }


   
    }
}
