﻿using System.ComponentModel;
using System.Web.UI;
[assembly: TagPrefix("Jinlong.Control", "Jinlong")]
namespace Jinlong.Control
{
    /// <summary>
    /// JRepeater控件
    /// Create by Jinlong Zhang
    /// </summary>

    [DefaultProperty("Text"), ToolboxData("<!--Repeater Begin --><div class=\"BigDiv_rep\"> <{0}:Repeater ID=\"Rep_List\" runat=server EnableViewState=\"false\" OnPreRender=\"Rep_List_PreRender\"> <HeaderTemplate><div class=\"BigDiv_Title_rep\"> <ul> <li style=\"line-height:22px;\"> <asp:CheckBox ID=\"TopCheckBox\" runat=\"server\" Text=\"ID\" EnableViewState=\"false\"/> </li><li style=\"width:10%;\"> </li>  </ul> </div> </HeaderTemplate><ItemTemplate><div class=\"BigDiv_line_rep\"  onmouseover=\"javascript:this.style.backgroundColor='#EEF8F9'\" onmouseout=\"javascript:this.style.backgroundColor='#FFFFFF'\"><ul ><li style=\"line-height:22px;\"><asp:CheckBox ID=\"ItemCheckBox\" runat=\"server\" Text='<%# Eval(\"ID\") %>'  EnableViewState=\"false\"/></li><li style=\"width:10%;\"></li></ul></div></ItemTemplate>   <FooterTemplate><div class=\"DelAllButton\"><asp:Button ID=\"btn_DelAll\" runat=\"server\" onclick=\"btn_DelAll_Click\"  CssClass=\"btn_DelAllCss\"  Text=\"删除\"  EnableViewState=\"false\"/></div></FooterTemplate></{0}:Repeater></div><!--Repeater End -->")]
    public class Repeater : System.Web.UI.WebControls.Repeater
    {
        private int _recordcount = 0;
        private int _pagesize = 0;
        private string _pagelink = "";
        private int _currentpage = 1;
        /// <summary>
        /// 构造函数
        /// </summary>
        public Repeater()
		{

        }

        #region __________属性__________

        [Bindable(true), Category("Data"), DefaultValue("1"), Description("记录总数")]
        public int RecordCount
        {
            get
            {
                return _recordcount;
            }

            set
            {
                _recordcount = value;
            }
        }

        [Bindable(true), Category("Data"), DefaultValue("1"), Description("每页显示记录数")]
        public int PageSize
        {
            get
            {
                return _pagesize;
            }

            set
            {
                _pagesize = value;
            }
        }

        [Bindable(true), Category("Data"), DefaultValue(""), Description("当前页链接")]
        public string PageLink
        {
            get
            {
                return _pagelink;
            }

            set
            {
                _pagelink = value;
            }
        }

        [Bindable(true), Category("Data"), DefaultValue("1"), Description("当前页")]
        public int CurrentPage
        {
            get
            {
                return _currentpage;
            }

            set
            {
                _currentpage = value;
            }
        }

        #endregion


 
        /// <summary> 
        /// 输出html,在浏览器中显示控件
        /// </summary>
        /// <param name="output"> 要写出到的 HTML 编写器 </param>
        protected override void Render(HtmlTextWriter output)
        {
            base.Render(output);
 
            output.WriteLine("<div class=\"PageLink\">" + Pagination(_recordcount, _pagesize, _currentpage, _pagelink) + "</div>");
        }


        /// <summary>
        /// 分页函数
        /// </summary>
        /// <param name="recordcount">总记录数</param>
        /// <param name="pagesize">每页记录数</param>
        /// <param name="currentpage">当前页数</param>
        /// <param name="url">Url参数</param>
        /// <returns></returns>
        public string Pagination(int recordcount, int pagesize, int currentpage, string url)
        {
            int allcurrentpage = 0;
            int next = 0;
            int pre = 0;
            int startcount = 0;
            int endcount = 0;
            string currentpagestr = "";

            if (currentpage < 1) { currentpage = 1; }
            //计算总页数
            if (pagesize != 0)
            {
                allcurrentpage = (recordcount / pagesize);
                allcurrentpage = ((recordcount % pagesize) != 0 ? allcurrentpage + 1 : allcurrentpage);
                allcurrentpage = (allcurrentpage == 0 ? 1 : allcurrentpage);
            }
            next = currentpage + 1;
            pre = currentpage - 1;
            startcount = (currentpage + 5) > allcurrentpage ? allcurrentpage - 9 : currentpage - 4;//中间页起始序号
            //中间页终止序号
            endcount = currentpage < 5 ? 10 : currentpage + 5;
            if (startcount < 1) { startcount = 1; } //为了避免输出的时候产生负数，设置如果小于1就从序号1开始
            if (allcurrentpage < endcount) { endcount = allcurrentpage; }//页码+5的可能性就会产生最终输出序号大于总页码，那么就要将其控制在页码数之内
            currentpagestr = "共" + allcurrentpage + "页&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

            currentpagestr += currentpage > 1 ? "<a href=\"" + url + "?page=1\">首页</a>&nbsp;&nbsp;<a href=\"" + url + "?page=" + pre + "\">上一页</a>" : "首页 上一页";
            //中间页处理，这个增加时间复杂度，减小空间复杂度
            for (int i = startcount; i <= endcount; i++)
            {
                currentpagestr += currentpage == i ? "&nbsp;&nbsp;<font color=\"#ff0000\">" + i + "</font>" : "&nbsp;&nbsp;<a href=\"" + url + "?page=" + i + "\">" + i + "</a>";
            }
            currentpagestr += currentpage != allcurrentpage ? "&nbsp;&nbsp;<a href=\"" + url + "?page=" + next + "\">下一页</a>&nbsp;&nbsp;<a href=\"" + url + "?page=" + allcurrentpage + "\">末页</a>" : " 下一页 末页";
            return currentpagestr;
        }

    }
}
