﻿$(document).ready(function() {
    $.Index();
});
jQuery.extend({
    AjaxStart: function() {
        var sWidth = Math.max(document.body.scrollWidth, document.documentElement.clientWidth);
        var sHeight = Math.max(document.body.scrollHeight, document.documentElement.clientHeight);
        var bgObj = document.createElement("div");
        bgObj.setAttribute('id','bgDiv');
        bgObj.style.position = "absolute";
        bgObj.style.top = "0";
        bgObj.style.filter = "alpha(opacity=50)";
        bgObj.style.opacity = "0.5";
        bgObj.style.left = "0";
        bgObj.style.width = sWidth + "px";
        bgObj.style.height = sHeight + "px";
        bgObj.style.zIndex = "999";
        bgObj.style.background = "#666";
        $('#mi').append(bgObj);
        
        var msgObj = document.createElement("div")
        msgObj.setAttribute("id","msgDiv");
        msgObj.setAttribute("align","center");
        msgObj.style.position = "absolute";
        msgObj.style.left = (sWidth - 126) / 2 + "px";
        msgObj.style.top = (sHeight - 22) / 2 + "px";
        msgObj.style.font = "12px/1.6em Verdana, Geneva, Arial, Helvetica, sans-serif";
        msgObj.style.margin = "0";
        msgObj.style.width = "126px";
        msgObj.style.height = "22px";
        msgObj.style.textAlign = "center";
        msgObj.style.lineHeight ="25px";
        msgObj.style.zIndex = "999";
        
        $('#mi').append(msgObj);
        var txt = document.createElement("p");
        txt.setAttribute("id","msgTxt");
        txt.innerHTML = '<img src="../Images/Common/Loading.gif" alt="Loading..." />';
        $('#msgDiv').append(txt);
    },
    AjaxEnd: function() {
        $('#bgDiv').remove();
        $('#msgDiv').remove();
    },
    Index: function() {
        $.ajax({
            type: 'get',
            dataType: 'json',
            url: 'Script/Setup.ashx',
            beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                $('#mt').html(msg.Title);
                $('#mb').html(msg.Desc);
                $('#mi').html(msg.Info);
                $('#mh').css({height: msg.Height});
                $('#btn').html(msg.Button);
                $('#Next').click(function() {
                    $.License();
                });
            }
        });
    },
    License: function() {
        $.ajax({
            type: 'get',
            dataType: 'json',
            url: 'Script/Setup.ashx?Action=License',
            beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                $('#mt').html(msg.Title);
                $('#mb').html(msg.Desc);
                $('#mi').html(msg.Info);
                $('#mh').css({height: msg.Height});
                $('#btn').html(msg.Button);
                $('#chkAgree').click(function() {
                    if($('#chkAgree').attr('checked') != undefined)
                        $('#Next').attr('disabled', '');
                    else
                        $('#Next').attr('disabled', 'disabled');
                });
                $('#Previous').click(function() {
                    $.Index();
                });
                $('#Next').click(function() {
                    $.CheckRun();
                });
            }
        });
    },
    CheckRun: function() {
        $.ajax({
            type: 'get',
            dataType: 'json',
            url: 'Script/Setup.ashx?Action=CheckRun',
            beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                $('#mt').html(msg.Title);
                $('#mb').html(msg.Desc);
                $('#mi').html(msg.Info);
                $('#mh').css({height: msg.Height});
                $('#btn').html(msg.Button);
                if(msg.State == 0)
                    $('#Next').attr('disabled', '');
                $('#Previous').click(function() {
                    $.License();
                });
                $('#Next').click(function() {
                    $.Connect();
                });
            }
        });
    },
    Connect: function() {
        $.ajax({
            type: 'get',
            dataType: 'json',
            url: 'Script/Setup.ashx?Action=Connect',
            beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                $('#mt').html(msg.Title);
                $('#mb').html(msg.Desc);
                $('#mi').html(msg.Info);
                $('#mh').css({height: msg.Height});
                $('#btn').html(msg.Button);
                $('#Previous').click(function() {
                    $.CheckRun();
                });
                $('#Next').click(function() {
                    $.SelectDB();
                });
            }
        });
    },
    SelectDB: function() {
        $('#ErrShow').html('');
        var dbhost = $('#dbhost').val();
        var dbuser = $('#dbuser').val();
        var dbpass = $('#dbpass').val();
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'Script/Setup.ashx?Action=SelectDB',
            data: 'dbhost=' + dbhost + '&dbuser=' + dbuser + '&dbpass=' + dbpass,
            beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                if(msg.State == 0) {
                    $('#mt').html(msg.Title);
                    $('#mb').html(msg.Desc);
                    $('#mi').html(msg.Info);
                    $('#mh').css({height: msg.Height});
                    $('#btn').html(msg.Button);
                    $('#nlist').html(msg.DBList);
                    $('#Previous').click(function() {
                        $.Connect();
                    });
                    $("input[name='selDB']").click(function() {
                        if($("input[name='selDB'][checked]").val() == '1') {
                            $('#nlist').html(msg.DBNew);
                        } else {
                            $('#nlist').html(msg.DBList);
                        }
                    });
                    $('#Next').click(function() {
                        $.Import(dbhost, dbuser, dbpass);
                    });
                } else {
                    $('#ErrShow').html(msg.Msg);
                }
            }
        });
    },
    Import: function(dbhost, dbuser, dbpass) {
    	var dbname = '';
    	var newDB = 'No';
    	if($("input[name='selDB'][checked]").val() == '0') {
    		dbname = $('#dblist').val();
    	} else {
    		dbname = $('#dbnew').val();
    		newDB = 'Yes';
    	}
        $.ajax({
        	type: 'post',
        	dataType: 'json',
        	url: 'Script/Setup.ashx?Action=Import',
        	data: 'dbhost=' + dbhost + '&dbuser=' + dbuser + '&dbpass=' + dbpass + '&dbname=' + dbname + '&NewDB=' + newDB,
        	beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                if(msg.State == 0) {
                    $.CreateUser(dbhost, dbuser, dbpass, dbname);
                } else {
                    $('#mb').html('<div id="ErrShow" style="color:red;"></div><br />');
                    $('#ErrShow').html(msg.Msg);
                }
            }
        });
    },
    CreateUser: function(dbhost, dbuser, dbpass, dbname) {
        $.ajax({
            type: 'get',
        	dataType: 'json',
        	url: 'Script/Setup.ashx?Action=CreateUser',
        	beforeSend: function() {
                $.AjaxStart();
            },
            complete: function() {
                $.AjaxEnd();
            },
            success: function(msg) {
                $('#mt').html(msg.Title);
                $('#mb').html(msg.Desc);
                $('#mi').html(msg.Info);
                $('#mh').css({height: msg.Height});
                $('#btn').html(msg.Button);
                $('#Previous').click(function() {
                    $.SelectDB();
                });
                $('#Next').click(function() {
                    $.End(dbhost, dbuser, dbpass, dbname);
                });
            }
        });
    },
    End: function(dbhost, dbuser, dbpass, dbname) {
        $('#mb').html('<div id="ErrShow" style="color:red;"></div><br />');

        if($('#loginname').val().length <= 0)
            $('#ErrShow').html($('#ErrShow').html() + '登录帐号不可为空<br />');
        
        if($('#username').val().length <= 0)
            $('#ErrShow').html($('#ErrShow').html() + '用户昵称不可为空<br />');
        
        if($('#userpass').val() != $('#userpass2').val())
            $('#ErrShow').html($('#ErrShow').html() + '两次输入密码不相同<br />');
        
        if($('#userpass').val().length < 8)
            $('#ErrShow').html($('#ErrShow').html() + '用户密码不可小雨8位数<br />');
        
        if($('#email').val().length <= 0)
            $('#ErrShow').html($('#ErrShow').html() + '管理邮箱不可为空<br />');
        
        if($('#loginname').val().length > 0 && $('#username').val().length > 0 && $('#userpass').val() == $('#userpass2').val() && $('#userpass').val().length >= 8 && $('#email').val().length > 0) {
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: 'Script/Setup.ashx?Action=End',
                data: 'dbhost=' + dbhost + '&dbuser=' + dbuser + '&dbpass=' + dbpass + '&dbname=' + dbname + '&loginname=' + $('#loginname').val() + '&username=' + $('#username').val() + '&userpass=' + $('#userpass').val() + '&email=' + $('#email').val(),
                beforeSend: function() {
                    $.AjaxStart();
                },
                complete: function() {
                    $.AjaxEnd();
                },
                success: function(msg) {
                    if(msg.State == 0) {
                        $('#mt').html(msg.Title);
                        $('#mi').html(msg.Info);
                        $('#mh').css({height: msg.Height});
                        $('#btn').html(msg.Button);
                        $('#close').click(function() {
                            window.close();
                        });
                    } else {
                        $('#ErrShow').html(msg.Msg);
                    }
                }
            });
        }
    }
});