﻿CREATE TABLE [Yom_Admin]  -- 管理员信息表
(
  [AdminID] INT PRIMARY KEY IDENTITY(1, 1) ,  -- 管理员编号
  [LoginName] NVARCHAR(50) NOT NULL , -- 管理员登陆名
  [LoginPass] NVARCHAR(32) NOT NULL , -- 管理员登录密码
  [UserName] NVARCHAR(50) NOT NULL ,  -- 管理员昵称
  [Email] NVARCHAR(100) NOT NULL -- 管理员邮件地址
)

GO

CREATE TABLE [Yom_Category] -- 分类信息表
(
  [CategoryID] INT PRIMARY KEY IDENTITY(1, 1) ,  -- 分类编号
  [Categoryname] NVARCHAR(50) NOT NULL ,  -- 分类名称
  [SaveName] NVARCHAR(80) NOT NULL ,  -- 分类保存目录文件名
  [SeoKey] NVARCHAR(120) ,  -- Meta 关键字
  [SeoDes] NVARCHAR(200)  -- Meta 描述
)

GO

CREATE TABLE [Yom_Chapter]  -- 章节信息表
(
  [ChapterID] BIGINT PRIMARY KEY IDENTITY(1, 1) , -- 章节编号
  [VolumeID] BIGINT NOT NULL ,  -- 所属分卷编号
  [ImgPath] NVARCHAR(120) NOT NULL ,  -- 漫画图片保存路径
  [OrderID] INT DEFAULT 0 -- 章节排序编号
)

GO

CREATE TABLE [Yom_Comic]  -- 漫画信息表
(
  [ComicID] BIGINT PRIMARY KEY IDENTITY(1, 1) , -- 漫画编号
  [CategoryID] INT NOT NULL , -- 所属分类编号
  [Author] NVARCHAR(50) NOT NULL , -- 漫画作者
  [FaceExt] NVARCHAR(10) NOT NULL ,	-- 封面后缀
  [Initial] CHAR(1) NOT NULL ,  -- 漫画所属字符
  [ComicName] NVARCHAR(80) NOT NULL , -- 漫画名称
  [OtherName] NVARCHAR(80) ,  -- 漫画其他名称
  [State] TINYINT NOT NULL DEFAULT 0 ,  -- 漫画状态, 0为连载, 1为暂停, 2为完结
  [Tag] NTEXT , -- 漫画关键字
  [Intro] TEXT NOT NULL , -- 漫画简介
  [Language] TINYINT NOT NULL , -- 漫画语言, 0为简体, 1为繁体, 2为日语, 3为英语, 4为其他
  [Color] TINYINT NOT NULL ,  -- 漫画颜色, 0为黑色, 1为彩色, 2为未知
  [IsTop] BIT DEFAULT 'False' , -- 是否推荐
  [IsCheck] BIT DEFAULT 'False' , -- 是否显示
  [Visit] INT DEFAULT 0 , -- 阅读数量
  [JoinTime] DATETIME , -- 加入时间
  [LastTime] DATETIME -- 最后更新时间
)

GO

CREATE TABLE [Yom_Link] -- 友情链接信息表
(
  [LinkID] INT PRIMARY KEY IDENTITY(1, 10) ,  -- 友情链接编号
  [LinkName] NVARCHAR(80) NOT NULL ,  -- 网站名称
  [LinkUrl] NVARCHAR(120) NOT NULL ,  -- 网站地址
  [IsCheck] BIT DEFAULT 'False' -- 是否显示
)

GO

CREATE TABLE [Yom_Note] -- 公告信息表
(
  [NoteID] INT PRIMARY KEY IDENTITY(1, 1) , -- 公告编号
  [AdminID] INT NOT NULL ,  -- 发布管理员编号
  [Title] NVARCHAR(120) NOT NULL ,  -- 公告标题
  [Content] TEXT NOT NULL ,  -- 公告内容
  [Url] NVARCHAR(150) , -- 外部链接地址
  [IsTop] BIT DEFAULT 'False' , -- 是否置顶
  [PostTime] DATETIME NOT NULL ,  -- 发布时间
  [PostIP] NVARCHAR(15) NOT NULL  -- 发布IP地址
)

GO

CREATE TABLE [Yom_Setting]  -- 网站配置信息表
(
  [SetID] INT PRIMARY KEY ,
  [BottomDesc] NTEXT ,	 -- 网站底部说明
  [CopyRight] NTEXT ,	-- 版权
  [Description] NTEXT ,	-- Meta描述
  [Ext] NVARCHAR(50) ,	-- 静态文件后缀名
  [KeyWords] NTEXT ,	-- Meta关键字
  [Locale] NVARCHAR(50) ,	 -- 网站语言
  [SaveFace] NVARCHAR(150) ,	-- 封面图片保存路径
  [SiteTitle] NVARCHAR(100) ,	-- 网站名称
  [SiteUrl] NVARCHAR(200) ,	-- 网站域名
  [Theme] NVARCHAR(50) ,	-- 网站模板
)

GO

CREATE TABLE [Yom_Volume] -- 分卷信息表
(
  [VolumeID] BIGINT PRIMARY KEY IDENTITY(1, 1) ,  -- 分卷编号
  [ComicID] BIGINT NOT NULL , -- 所属漫画编号
  [VolumeName] NVARCHAR(80) NOT NULL ,  -- 分卷名称
  [OrderID] INT DEFAULT 0 -- 分卷排序编号
)

GO