﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ComponentModel.DataAnnotations;
using System.ComponentModel;

namespace VS2008SP1.Business
{
    /*
     * Scaffold - 译为基架。即基于数据库架构（linq to sql 或 entity framework）生成网页模板的机制
     * ScaffoldTableAttribute(false) - 隐藏指定的表
     * ScaffoldColumn(false) - 隐藏指定的字段
     * MetadataTypeAttribute(Type metadataClassType) - 指定要与数据模型类关联的元数据类
     */

    [ScaffoldTable(false)]
    public partial class Region
    {
        // Region 表不会被路由（显示）
    }

    [MetadataType(typeof(Customers_Metadata))]
    public partial class Customers
    {
        // 将 Customers 的元数据关联到 Customers_Metadata
    }

    public class Customers_Metadata
    {
        [ScaffoldColumn(false)]
        public object Phone;

        // Phone 不会在 Customers 表中被显示
    }
}
