﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ComponentModel.DataAnnotations;
using System.ComponentModel;

namespace VS2008SP1.Business
{
    [MetadataType(typeof(Products_Metadata))]
    public partial class Products
    {
        // entity framework 会自动生成类似 OnFieldChanging() 的部分方法
        // 如果想做字段的自定义输入验证，则可以重写此方法
        partial void OnUnitPriceChanging(global::System.Nullable<decimal> value)
        {
            if (value > 1000)
            {
                throw new ValidationException("UnitPrice 不能大于 1000");
            }
        }
    }

    public class Products_Metadata
    {
        // [DataType(DataType.EmailAddress)] // 指定要与数据字段关联的附加类型的名称
        // [DisplayFormat()] // 格式化输出
        // [Range()] // 指定字段的范围约束
        // [RegularExpression()] // 正则表达式验证
        // [StringLength()] // 字段的字符长度验证
        [Required()] // 必填
        [UIHint("MyDecimal")] // 使用名为 MyDecimal 的字段模板
        public object UnitPrice;

        [DisplayName("产品名称")] // 指定的字段所显示的名称。在动态数据中，查看 Products 表，其 header 将显示为 产品名称
        [StartsWith("webabcd", ErrorMessage = "{0} 必须以 {1} 开头")] // 应用自定义 ValidationAttribute
        public object ProductName { get; set; }

    }


    // 编写一个自定义 ValidationAttribute，验证指定字段是否是以指定的字符串开头
    [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field, AllowMultiple = false)]
    sealed public class StartsWithAttribute : ValidationAttribute
    {
        readonly string _param;

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="param">指定的开头字符串</param>
        public StartsWithAttribute(string param)
        {
            _param = param;
        }

        /// <summary>
        /// 是否通过验证
        /// </summary>
        /// <param name="value">输入值</param>
        /// <returns></returns>
        public override bool IsValid(object value)
        {
            return ((string)value).ToLower().StartsWith(this._param.ToLower());
        }

        /// <summary>
        /// 格式化错误信息
        /// </summary>
        /// <param name="name">指定的字段名</param>
        /// <returns></returns>
        public override string FormatErrorMessage(string name)
        {
            return string.Format(ErrorMessageString, name, this._param);
        }
    }
}
